package pt.digitalis.dif.startup.checks;

import org.apache.commons.lang.SystemUtils;
import pt.digitalis.dif.startup.DIFStartupConfiguration;
import pt.digitalis.dif.startup.IStartupCheck;
import pt.digitalis.dif.startup.StartupCheckResult;
import pt.digitalis.utils.inspection.ResourceUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * The type Startup check java version.
 */
public class StartupCheckJavaVersion implements IStartupCheck
{

    /**
     * Is mandatory boolean.
     *
     * @return the boolean
     */
    @Override
    public boolean isMandatory()
    {
        return !DIFStartupConfiguration.getAllowIncompatibleJavaToInitializeDIF();
    }

    /**
     * Validate startup check result.
     *
     * @return the startup check result
     */
    @Override
    public StartupCheckResult validate()
    {
        final String bouncyCastleJARName = "bcprov-jdk15-1.46.jar";
        final String iTextJARName = "itextpdf-5.1.0.jar";
        final String requiredJavaVersion = "1.6.0";
        final int requiredJavaVersionPatch = 141;

        String javaVersion = System.getProperty("java.version");
        List<String> errors = new ArrayList<String>();

        Integer patch = 0;
        String[] split = javaVersion.split("_");

        if (split.length > 1)
            patch = Integer.valueOf(split[1]);

        boolean javaVersionCheck = SystemUtils.JAVA_VERSION_INT >= 170 ||
                                   (SystemUtils.JAVA_VERSION_INT == 160 && patch >= requiredJavaVersionPatch);
        boolean bouncyCastleExists = ResourceUtils.isJarFileExist(bouncyCastleJARName);
        boolean iText5Exists = ResourceUtils.isJarFileExist(iTextJARName);

        if (javaVersionCheck && bouncyCastleExists && iText5Exists)
            return new StartupCheckResult(true);
        else
        {
            errors.add("[" + (javaVersionCheck ? " OK " : "FAIL") + "] JDK (found: " + javaVersion + ", required: " +
                       requiredJavaVersion + "_" + requiredJavaVersionPatch + ")");
            errors.add("[" + (bouncyCastleExists ? " OK " : "FAIL") +
                       "] JAR in classpath (should be present in the JRE): " + bouncyCastleJARName);
            errors.add("[" + (iText5Exists ? " OK " : "FAIL") +
                       "] JAR in classpath (should be present in the application): " + iTextJARName);

            return new StartupCheckResult(false, errors);
        }
    }
}
