/**
 * 2018, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */

package pt.digitalis.dif.utils;

import java.util.List;

/**
 * Defines the possibility to export the object properties to an object formatter
 *
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a><br/>
 * @created Aug 2, 2019
 */
public interface IObjectFormatter
{

    /**
     * Converts the object properties to an object formatter.
     *
     * @param format        the desired format
     * @param dumpedObjects the already dumped objects for inner objects to be rendered inside others
     *
     * @return the object formatter
     */
    public ObjectFormatter toObjectFormatter(ObjectFormatter.Format format, List<Object> dumpedObjects);
}
