package pt.digitalis.dif.utils;

/**
 * Abstracts the various implementations of pagination
 *
 * @author Fbio Souto <a href="mailto:fsouto@digitalis.pt">fsouto@digitalis.pt</a><br/>
 * @created 9 de Nov de 2011
 */
public class Pagination
{

    /** The page to be presented */
    private int page = 0;

    /** The limit of results per page */
    private int rowsPerPage = 0;

    /**
     * Instantiates a new pagination object. The limit is always required, and at least one of the two parameters (page
     * or start)
     *
     * @param page        The page to be presented or null (start required)
     * @param rowsPerPage The limit of results per page
     */
    public Pagination(Integer page, Integer rowsPerPage)
    {
        this.page = page;
        this.rowsPerPage = rowsPerPage;
    }

    /**
     * Get the end row
     *
     * @return the end row
     */
    public int getEndRow()
    {
        return this.page * this.rowsPerPage;
    }

    /**
     * Get the page to be fetched
     *
     * @return The page to be fetched
     */
    public int getPage()
    {
        return this.page;
    }

    /**
     * Get the limit of results per page
     *
     * @return The limit of results per page
     */
    public int getRowsPerPage()
    {
        return this.rowsPerPage;
    }

    /**
     * Get the start row
     *
     * @return the start row
     */
    public int getStartRow()
    {
        return (this.page - 1) * this.rowsPerPage;
    }
}
