package pt.digitalis.dif.utils.configurations;

import pt.digitalis.dif.ioc.DIFIoCRegistry;
import pt.digitalis.utils.config.ConfigurationException;
import pt.digitalis.utils.config.IConfigurations;

import java.util.Properties;

/**
 * @author Luis Pinto <a href="mailto:lpinto@digitalis.pt">lpinto@digitalis.pt</a><br/>
 * @created Jan 8, 2014
 */
public abstract class AbstractApplicationModelConfigurations implements IApplicationModelConfigurations
{

    /** The configuration manager instance */
    static private IConfigurations configurations;

    /**
     * @return the configurations
     */
    protected static IConfigurations getConfigurations()
    {
        if (configurations == null)
            configurations = DIFIoCRegistry.getRegistry().getImplementation(IConfigurations.class);

        return configurations;
    }

    /**
     * @see pt.digitalis.dif.utils.configurations.IApplicationModelConfigurations#getAllDatabaseConfigurations()
     */
    public Properties getAllDatabaseConfigurations()
    {
        return null;
    }

    /**
     * @see pt.digitalis.dif.utils.configurations.IApplicationModelConfigurations#getCustomDatabaseConfigurations()
     */
    public Properties getCustomDatabaseConfigurations() throws ConfigurationException
    {
        return null;
    }
}
