/**
 * 2009, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */

package pt.digitalis.dif.utils.configurations;

import pt.digitalis.utils.config.ConfigurationException;

import java.util.Properties;

/**
 * @author Luis Pinto <a href="mailto:lpinto@digitalis.pt">lpinto@digitalis.pt</a><br/>
 * @created Jan 8, 2014
 */
public interface IApplicationModelConfigurations
{

    /**
     * Get the all database configurations for the application
     *
     * @return the database configurations
     */
    public Properties getAllDatabaseConfigurations();

    /**
     * Get the custom database configurations for the application
     *
     * @return the database configurations
     *
     * @exception ConfigurationException
     */
    public Properties getCustomDatabaseConfigurations() throws ConfigurationException;
}
