/**
 * 2014, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */

package pt.digitalis.dif.utils.extensions;

import pt.digitalis.dif.controller.interfaces.IDIFContext;

/**
 * Defines the Captcha functionality. @see http://en.wikipedia.org/wiki/CAPTCHA
 *
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a><br/>
 * @created 02/07/2014
 */
public interface ICaptcha
{

    /** The id of the parameter that has the captcha value */
    final static public String CAPTCHA_INPUT_ID = "captchaValue";

    /** The parameter that indicates that a captcha field is present. */
    final static public String CAPTCHA_PRESENT = "captcha_field_present";

    /**
     * Fetches the captcha required generated form the current stage context request
     *
     * @param context the current stage instance context
     *
     * @return the captcha required value
     */
    public String getCaptchaRequiredValue(IDIFContext context);

    /**
     * Fetches the captcha value form the current stage context request
     *
     * @param context the current stage instance context
     *
     * @return the captcha submited value
     */
    public String getCaptchaSubmitedValue(IDIFContext context);

    /**
     * Validates the submited captcha value
     *
     * @param context the current stage instance context
     *
     * @return true if the submited captcha value is valid
     */
    public boolean isCaptchaValueValid(IDIFContext context);
}
