/**
 * 2010, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */

package pt.digitalis.dif.utils.extensions.cms;

/**
 * An ACL (Access control list) item definition for content nodes and items
 *
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a><br/>
 * @created 2010/10/06
 */
public class ACLEntry
{

    /** the group ID */
    private String groupID;

    /** the user ID */
    private String userID;

    /**
     * Inspector for the 'groupID' attribute.
     *
     * @return the groupID value
     */
    public String getGroupID()
    {
        return groupID;
    }

    /**
     * Modifier for the 'groupID' attribute.
     *
     * @param groupID the new groupID value to set
     */
    public void setGroupID(String groupID)
    {
        this.groupID = groupID;
    }

    /**
     * Inspector for the 'userID' attribute.
     *
     * @return the userID value
     */
    public String getUserID()
    {
        return userID;
    }

    /**
     * Modifier for the 'userID' attribute.
     *
     * @param userID the new userID value to set
     */
    public void setUserID(String userID)
    {
        this.userID = userID;
    }

    /**
     * @return T if the current ACL entry defines a group access
     */
    public boolean isGroupEntry()
    {
        return groupID != null;
    }

    /**
     * @return T if the current ACL entry defines a user access
     */
    public boolean isUserEntry()
    {
        return userID != null;
    }
}
