/**
 * 2008, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */

package pt.digitalis.dif.utils.extensions.cms.exception;

/**
 * This exception occurs when a user tries to insert a content item in a node that already has a content item with the
 * same name
 *
 * @author Nuno Bravo
 * @created Out 20, 2010
 */
public class ContentItemWithDuplicateNameAndParentNodeException extends ContentManagerException
{

    /**
     *
     */
    private static final long serialVersionUID = 1L;

    /**
     *
     */
    public ContentItemWithDuplicateNameAndParentNodeException()
    {
        super("Content with duplicate name and parent node");
    }

    /**
     * @param exception
     */
    public ContentItemWithDuplicateNameAndParentNodeException(Exception exception)
    {
        super(exception);
    }

    /**
     * @param contentId
     */
    public ContentItemWithDuplicateNameAndParentNodeException(Long contentId)
    {
        super("Content with duplicate name and parent node. Content with id: " + contentId);
    }

    /**
     * @param reason
     */
    public ContentItemWithDuplicateNameAndParentNodeException(String reason)
    {
        super(reason);
    }
}
