/**
 * 2008, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */

package pt.digitalis.dif.utils.extensions.cms.exception;

/**
 * This exception occurs when an a CMS operation is done with an invalid parent node reference
 *
 * @author Nuno Bravo
 * @created Out 20, 2010
 */
public class InvalidParentNodeException extends ContentManagerException
{

    /**
     *
     */
    private static final long serialVersionUID = 1L;

    /**
     *
     */
    public InvalidParentNodeException()
    {
        super("Parent node does not exists");
    }

    /**
     * @param exception
     */
    public InvalidParentNodeException(Exception exception)
    {
        super(exception);
    }

    /**
     * @param nodeId
     */
    public InvalidParentNodeException(Long nodeId)
    {
        super("Content with invalid parent node. Parent node with id: " + nodeId);
    }

    /**
     * @param reason
     */
    public InvalidParentNodeException(String reason)
    {
        super(reason);
    }
}
