/**
 * 2008, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */

package pt.digitalis.dif.utils.extensions.cms.exception;

/**
 * This exception occurs when there is a search of a Node in the repository and the Node is not found
 *
 * @author Nuno Bravo
 * @created Out 20, 2010
 */
public class NodeNotFoundException extends ContentManagerException
{

    /**
     *
     */
    private static final long serialVersionUID = 1L;

    /**
     *
     */
    public NodeNotFoundException()
    {
        super("node not found");
    }

    /**
     * @param exception
     */
    public NodeNotFoundException(Exception exception)
    {
        super(exception);
    }

    /**
     * @param nodeId
     */
    public NodeNotFoundException(Long nodeId)
    {
        super("Node not found with id: " + nodeId);
    }

    /**
     * @param reason
     */
    public NodeNotFoundException(String reason)
    {
        super(reason);
    }
}
