/**
 * 2008, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */

package pt.digitalis.dif.utils.extensions.cms.exception;

/**
 * This exception occurs when a user tries to insert a node with a path that already exists
 *
 * @author Nuno Bravo
 * @created Out 20, 2010
 */
public class NodeWithDuplicatePathException extends ContentManagerException
{

    /**
     *
     */
    private static final long serialVersionUID = 1L;

    /**
     *
     */
    public NodeWithDuplicatePathException()
    {
        super("Node path already exists");
    }

    /**
     * @param exception
     */
    public NodeWithDuplicatePathException(Exception exception)
    {
        super(exception);
    }

    /**
     * @param nodeId
     */
    public NodeWithDuplicatePathException(Long nodeId)
    {
        super("Node with duplicate path with id: " + nodeId);
    }

    /**
     * @param reason
     */
    public NodeWithDuplicatePathException(String reason)
    {
        super(reason);
    }
}
