/**
 * 2009, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */

package pt.digitalis.dif.utils.extensions.document;

import pt.digitalis.dif.controller.interfaces.IDIFSession;

import java.util.ArrayList;
import java.util.List;

/**
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a><br/>
 * @created 11 de Mar de 2011
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a><br/>
 * @created 11 de Mar de 2011
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a><br/>
 * @created 11 de Mar de 2011
 */
/**
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a><br/>
 * @created 11 de Mar de 2011
 */

/**
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a><br/>
 * @created 11 de Mar de 2011
 */

/**
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a><br/>
 * @created 11 de Mar de 2011
 */
public abstract class AbstractDocumentRepository implements IDocumentRepositoryManager
{

    /**  */
    private static final String DOCUMENT_AUTHORIZATION_LIST = "authorizedDocuments";

    /**
     * @see pt.digitalis.dif.utils.extensions.document.IDocumentRepositoryManager#authorizeDocumentForCurrentSession(pt.digitalis.dif.controller.interfaces.IDIFSession,
     *      java.lang.Long)
     */
    public void authorizeDocumentForCurrentSession(IDIFSession session, Long documentID)
    {
        @SuppressWarnings("unchecked")
        List<Long> authorizedDocuments = (List<Long>) session.getAttribute(DOCUMENT_AUTHORIZATION_LIST);

        if (authorizedDocuments == null)
            authorizedDocuments = new ArrayList<Long>();

        if (!authorizedDocuments.contains(documentID))
            authorizedDocuments.add(documentID);

        session.addAttribute(DOCUMENT_AUTHORIZATION_LIST, authorizedDocuments);
    }

    /**
     * @see pt.digitalis.dif.utils.extensions.document.IDocumentRepositoryManager#getDocumentsByIds(java.util.List)
     */
    public synchronized List<DocumentRepositoryEntry> getDocumentsByIds(List<Long> documentIds)
            throws DocumentRepositoryException
    {
        List<DocumentRepositoryEntry> documents = new ArrayList<DocumentRepositoryEntry>();

        for (Long docId : documentIds)
        {
            documents.add(getDocument(docId));
        }

        return documents;
    }

    /**
     * @see pt.digitalis.dif.utils.extensions.document.IDocumentRepositoryManager#isDocumentAuthorizedInCurrentSession(pt.digitalis.dif.controller.interfaces.IDIFSession,
     *      java.lang.Long)
     */
    public boolean isDocumentAuthorizedInCurrentSession(IDIFSession session, Long documentID)
    {
        @SuppressWarnings("unchecked")
        List<Long> authorizedDocuments = (List<Long>) session.getAttribute(DOCUMENT_AUTHORIZATION_LIST);

        return authorizedDocuments != null && authorizedDocuments.contains(documentID);
    }
}
