package pt.digitalis.dif.utils.extensions.document;

/**
 * @author Luis Pinto <a href="mailto:lpinto@digitalis.pt">lpinto@digitalis.pt</a><br/>
 * @created Sep 22, 2009
 */
public class MaximumDocumentSizeException extends DocumentRepositoryException
{

    /**
     *
     */
    private static final long serialVersionUID = 1L;

    /** the limit defined when the exception was launched */
    private Integer limit;

    /**
     * MaximumSizeDocumentException constructor
     *
     * @param reason
     * @param limit
     */
    public MaximumDocumentSizeException(String reason, Integer limit)
    {
        super(reason);
        this.setLimit(limit);
    }

    /**
     * Inspector for the 'limit' attribute.
     *
     * @return the limit value
     */
    public Integer getLimit()
    {
        return limit;
    }

    /**
     * Modifier for the 'limit' attribute.
     *
     * @param limit the new limit value to set
     */
    private void setLimit(Integer limit)
    {
        this.limit = limit;
    }
}
