/**
 * 2009, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */

package pt.digitalis.dif.utils.extensions.document;

import pt.digitalis.dif.controller.interfaces.IDIFSession;

/**
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a><br/>
 * @created 11 de Mar de 2011
 */
public class UnauthorizedDocumentAccess extends DocumentRepositoryException
{

    /**
     *
     */
    private static final long serialVersionUID = 2042571585977559161L;

    /**
     * @param session    the DIF session
     * @param documentID the requested document ID
     */
    public UnauthorizedDocumentAccess(IDIFSession session, Long documentID)
    {
        super("Access to unauthorized document");
        addToExceptionContext("document ID", documentID);
        addToExceptionContext("Session", session);
    }
}
