/**
 * 2015, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */

package pt.digitalis.dif.utils.jobs;

import pt.digitalis.dif.exception.BusinessException;
import pt.digitalis.dif.utils.logging.DIFLogger;
import pt.digitalis.log.LogLevel;
import pt.digitalis.utils.config.ConfigurationException;

import java.util.HashMap;
import java.util.Map;

/**
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a><br/>
 * @created 25/11/2015
 */
public class DIFJobsManager
{

    /**
     *
     */
    static public Map<Long, DIFJob> jobs = new HashMap<Long, DIFJob>();

    /**
     *
     */
    private static Long currentID = 1L;

    /**
     * Adds a job to the manager<br/>
     * Will start it if it is configured as active.
     *
     * @param job the job to add
     *
     * @exception ConfigurationException
     */
    public static void addJob(DIFJob job) throws ConfigurationException
    {
        if (jobs.containsValue(job))
        {
            DIFLogger.getLogger().debug("DIF Job [" + job.getJobName() +
                                        "] was not added since it was already present in the Manager.");
        }
        else
        {
            if (job.getJobType() == JobType.SINGLE_EXECUTION)
            {
                new BusinessException("Cannot add SINGLE_EXECUTION jobs to the DIF Jobs Manager")
                        .addToExceptionContext("Job", job).log(LogLevel.WARN);
            }
            else
            {
                job.setJobID(currentID++);
                job.readConfig(); // Load customized properties
                jobs.put(job.getJobID(), job);

                if (!job.isAlive())
                {
                    job.start();
                }
            }
        }
    }

    /**
     * @return the declared jobs
     */
    public static Map<Long, DIFJob> getJobs()
    {
        return jobs;
    }
}
