/**
 * 2015, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */

package pt.digitalis.dif.utils.jobs;

import pt.digitalis.utils.config.ConfigurationException;

/**
 * Base class for a recurrent job. Runs forever at set intervals
 *
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a><br/>
 * @created 25/11/2015
 */
public abstract class RecurrentJob extends DIFJob
{

    /**
     * In this case no session makes sense to pass. A RecurrentJob is a System Job and not a user task
     */
    public RecurrentJob()
    {
        super(null, false);
        // TODO: netPA: Viegas: RGPD - Implement the super mode that has access to the data
        this.setForceAccessToEncriptedData(true);
    }

    /**
     * @see pt.digitalis.dif.utils.jobs.DIFJob#getJobType()
     */
    @Override
    public final JobType getJobType()
    {
        return JobType.RECURRENT;
    }

    /**
     * @see java.lang.Thread#start()
     */
    @Override
    public synchronized void start()
    {
        super.start();

        try
        {
            DIFJobsManager.addJob(this);
        }
        catch (ConfigurationException e)
        {
            e.printStackTrace();
        }
    }
}
