/**
 * 2018, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */

package pt.digitalis.dif.utils.jobs;

/**
 * Defines a given time of day (hour and minute).
 *
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a><br/>
 * @created 26/08/2016
 */
public class TimeOfDay
{

    /** The hour. */
    private int hour;

    /** The minutes. */
    private int minutes;

    /**
     * Instantiates a new time of day.
     *
     * @param hour    the hour
     * @param minutes the minutes
     */
    public TimeOfDay(int hour, int minutes)
    {
        this.hour = hour;
        this.minutes = minutes;
    }

    /**
     * Instantiates a new time of day.
     *
     * @param time the time
     */
    public TimeOfDay(String time)
    {
        String[] splitHour = time.split(":");

        this.hour = new Integer(splitHour[0]);

        if (splitHour.length == 2)
            this.minutes = new Integer(splitHour[1]);
        else
            this.minutes = 0;
    }

    /**
     * Returns the representation of the time of day as a string (H:M).
     *
     * @return the string
     */
    public String asString()
    {
        return this.getHour() + ":" + this.getMinutes();
    }

    /**
     * Inspector for the 'hour' attribute.
     *
     * @return the hour value
     */
    public int getHour()
    {
        return hour;
    }

    /**
     * Inspector for the 'minutes' attribute.
     *
     * @return the minutes value
     */
    public int getMinutes()
    {
        return minutes;
    }
}
