/**
 * - Digitalis Internal Framework v2.0 -
 *
 * (C) 2007, Digitalis Informatica. 
 * 
 * Distribuicao e Gestao de Informatica, Lda.
 * Estrada de Paco de Arcos num.9 - Piso -1
 * 2780-666 Paco de Arcos
 * Telefone: (351) 21 4408990
 * Fax: (351) 21 4408999
 * http://www.digitalis.pt 
 */
package pt.digitalis.dif.utils.logging;

import pt.digitalis.log.LogLevel;
import pt.digitalis.dif.startup.DIFInitializer;

/**
 * Contains the logging logic to be applied on the DIF Initialization process.
 * 
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a>
 * @created Oct 9, 2007
 * 
 */
public final aspect DIFInitAspect extends DIFLogAspect {

    /** Keeps the class enhancing start timestamp */
    private long difInitStartTime;

    /** Captures the DEM Entity classes identifying process. */
    private pointcut DIFInitialization() : execution (* pt.digitalis.dif.startup.DIFInitializer.initialize()) && excludeLoggingAppliances();

    /**
     * Since the DIFInitializer.initialize() sets it's own initialization internal flag, if the aspect relies on the
     * DIFInitializer.isInitialized() method to execute the after():DIFInitialization advice, the advice body will never be picked up.
     * As such, the aspect must rely on another method to log the initialization time.
     */
    private boolean initializationInProgress = false;

    /**
     * Logs the DIF Initialization start
     */
    before() : DIFInitialization()
    {
        if (!DIFInitializer.isInitialized()) {
            difInitStartTime = System.currentTimeMillis();

            getLogger().log(LogLevel.INFO, "DIF Initialization started...");

            initializationInProgress = true;
        }
    }

    /**
     * Logs the DIF Initialization end
     */
    after() : DIFInitialization()
    {
        if (initializationInProgress) {
            getLogger().log(LogLevel.INFO,
                    "DIF Initialized in " + (System.currentTimeMillis() - difInitStartTime) + " ms.");

            initializationInProgress = false;
        }
    }
}
