/**
 * 2017, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */

package pt.digitalis.dif.utils.logging;

import org.apache.commons.collections4.queue.CircularFifoQueue;
import pt.digitalis.log.ILoggerInterceptor;
import pt.digitalis.utils.common.StringUtils;

import java.util.ArrayList;
import java.util.Collection;

/**
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a><br/>
 * @created 11/08/2017
 */
public class DIFLoggerInterceptor implements ILoggerInterceptor
{

    /** singleton instance */
    static private DIFLoggerInterceptor instance = null;

    /** the last lines in cache */
    CircularFifoQueue<String> lastLines = new CircularFifoQueue<String>(200);

    /** the last lines in cache (since last pool request) */
    CircularFifoQueue<String> lastLinesSinceLastPool = new CircularFifoQueue<String>(200);

    /**
     *
     */
    private boolean active = true;

    /**
     *
     */
    private DIFLoggerInterceptor()
    {
    }

    /**
     * Gets the singleton instance
     *
     * @return the instance
     */
    static public DIFLoggerInterceptor getInstance()
    {
        if (instance == null)
            instance = new DIFLoggerInterceptor();

        return instance;
    }

    /**
     * @return the last lines in cache
     */
    public Collection<String> getAllCachedLines()
    {
        return lastLines;
    }

    /**
     * @return the last new since the last call to this method
     */
    public Collection<String> getCachedLinesSinceLastPool()
    {
        ArrayList<String> lines;

        synchronized (lastLinesSinceLastPool)
        {
            lines = new ArrayList<String>(lastLinesSinceLastPool);
            lastLinesSinceLastPool.clear();
        }

        return lines;
    }

    /**
     * Inspector for the 'active' attribute.
     *
     * @return the active value
     */
    public boolean isActive()
    {
        return active;
    }

    /**
     * Modifier for the 'active' attribute.
     *
     * @param active the new active value to set
     */
    public void setActive(boolean active)
    {
        this.active = active;
    }

    /**
     * @see pt.digitalis.log.ILoggerInterceptor#onLogMessage(java.lang.String)
     */
    public void onLogMessage(String message)
    {
        if (isActive())
        {
            String messageToAdd = StringUtils.stripEnd(message, "\n\r ");

            for (String line : messageToAdd.split("\n"))
            {
                line = StringUtils.stripEnd(line, "\n\r ");
                this.lastLines.add(line);
                this.lastLinesSinceLastPool.add(line);
            }
        }
    }
}
