package pt.digitalis.dif.utils.logging.performance;

import java.util.Date;

/**
 * A piece of statistical information. The total number of requests and the average time it took to execute on a given
 * time slot
 *
 * @param <SampleClass> the sample data class
 *
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a><br/>
 * @created 19/07/2016
 */
public abstract class AbstractTimeStats<SampleClass extends Object>
{

    /**
     *
     */
    private Date date;

    /**
     * Constructor
     */
    public AbstractTimeStats()
    {
        this.date = new Date();
    }

    /**
     * Adds a new sample to the statistic slot
     *
     * @param sample the sample
     */
    public abstract void addSample(SampleClass sample);

    /**
     * Inspector for the 'averageTime' attribute.
     *
     * @return the averageTime value
     */
    public abstract long getAverageTime();

    /**
     * Inspector for the 'date' attribute.
     *
     * @return the date value
     */
    public Date getDate()
    {
        return date;
    }

    /**
     * Modifier for the 'date' attribute.
     *
     * @param date the new date value to set
     */
    public void setDate(Date date)
    {
        this.date = date;
    }
}