/**
 * 2016, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */

package pt.digitalis.dif.utils.logging.performance;

import pt.digitalis.dif.controller.interfaces.IDIFRequest;

import java.util.Collection;
import java.util.Queue;

/**
 * DIF Performance Logger specification. Will declare all that is required so that DIF can track time spent by stage
 * requests and allow monitoring and even data mining on this recorded data. May need a persistent repository for some
 * features
 *
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a><br/>
 * @created 22/08/2016
 */
public interface IPerformanceLogger
{

    /**
     * @return the list of tracked stage requests since DIF controller was started (restart will reset this data)
     */
    public Collection<StageRequestEntry> getStageRequestEntries();

    /**
     * Returns the stage access stats by day
     *
     * @return the statsByDay value
     */
    public Queue<TimeStats> getStatsByDay();

    /**
     * Returns the stage access stats by hour
     *
     * @return the statsByHour value
     */
    public Queue<TimeStats> getStatsByHour();

    /**
     * Returns the stage access stats by minute
     *
     * @return the statsByMinute value
     */
    public Queue<TimeStats> getStatsByMinute();

    /**
     * Logs a request
     *
     * @param request          the request
     * @param timeSpent        the time spent on it's execution
     * @param errorDescription if an error has accured it's description will be present here
     */
    public void logRequest(IDIFRequest request, Long timeSpent, String errorDescription);

    /**
     * Logs a request
     *
     * @param logData          the log data
     * @param timeSpent        the time spent on it's execution
     * @param errorDescription if an error has accured it's description will be present here
     */
    public void logRequest(LogRequestData logData, Long timeSpent, String errorDescription);
}
