/**
 * 2009, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */

package pt.digitalis.dif.utils.logging.performance;

import pt.digitalis.dif.controller.http.HTTPConstants;
import pt.digitalis.dif.controller.interfaces.IDIFRequest;
import pt.digitalis.dif.dem.interfaces.IStage;
import pt.digitalis.dif.dem.managers.IDEMManager;
import pt.digitalis.dif.dem.objects.EventType;
import pt.digitalis.dif.ioc.DIFIoCRegistry;
import pt.digitalis.utils.common.StringUtils;

/**
 * The Class LogData.
 *
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a><br/>
 * @created Sep 9, 2016
 */
public class LogRequestData
{

    /** The application ID. */
    private String applicationID;

    /** The client remote address. */
    private String clientRemoteAddress;

    /** The event ID. */
    private String eventID;

    /** The request dump. */
    private String requestDump;

    /** The request type. */
    private Character requestType;

    /** The service ID. */
    private String serviceID;

    /** The stage ID. */
    private String stageID;

    /** The user ID. */
    private String userID;

    /**
     * Instantiates a new log data.
     *
     * @param request the request
     */
    public LogRequestData(IDIFRequest request)
    {

        this.stageID = request.getStage();
        this.eventID = StringUtils.toStringOrNull(request.getParameter(HTTPConstants.EVENT_ID));
        this.userID = request.getSession().isLogged() ? request.getSession().getUser().getID() : null;
        this.clientRemoteAddress =
                StringUtils.toStringOrNull(request.getClient().getAttribute(HTTPConstants.CLIENT_REMOTE_ADDR));

        // Only calculate dump if it is needed
        if (PerformanceLoggerConfiguration.getInstance().getAuditRequests())
            this.requestDump = request.toString();

        IStage stage = DIFIoCRegistry.getRegistry().getImplementation(IDEMManager.class).getStage(this.stageID);

        boolean isSubmitForm = (request.getParameter(HTTPConstants.FORM_SUBMIT_STAGE) != null);
        boolean isAJAXRequest = request.isAjaxMode();
        boolean isDocumentRequest = false;

        if (stage != null)
        {
            this.applicationID = stage.getService().getApplication().getID();
            this.serviceID = stage.getService().getID();

            isDocumentRequest = (request.getParameter(HTTPConstants.DOCID_PARAMETER) != null || (eventID != null &&
                                                                                                 stage.getEventHandlers()
                                                                                                         .get(EventType.DOCUMENT_TYPE)
                                                                                                         .contains(
                                                                                                                 eventID)));
        }

        this.requestType = (isSubmitForm ? 'S' : (isDocumentRequest ? 'D' : (isAJAXRequest ? 'A' : 'P')));
    }

    /**
     * Instantiates a new log request data.
     *
     * @param applicationID       the application ID
     * @param serviceID           the service ID
     * @param stageID             the stage ID
     * @param eventID             the event ID
     * @param clientRemoteAddress the client remote address
     * @param requestDump         the request dump
     * @param requestType         the request type
     * @param userID              the user ID
     */
    public LogRequestData(String applicationID, String serviceID, String stageID, String eventID,
            String clientRemoteAddress, String requestDump, Character requestType, String userID)
    {
        super();
        this.applicationID = applicationID;
        this.clientRemoteAddress = clientRemoteAddress;
        this.eventID = eventID;
        this.requestDump = requestDump;
        this.requestType = requestType;
        this.serviceID = serviceID;
        this.stageID = stageID;
        this.userID = userID;
    }

    /**
     * Inspector for the 'applicationID' attribute.
     *
     * @return the applicationID value
     */
    public String getApplicationID()
    {
        return applicationID;
    }

    /**
     * Modifier for the 'applicationID' attribute.
     *
     * @param applicationID the new applicationID value to set
     */
    public void setApplicationID(String applicationID)
    {
        this.applicationID = applicationID;
    }

    /**
     * Inspector for the 'clientRemoteAddress' attribute.
     *
     * @return the clientRemoteAddress value
     */
    public String getClientRemoteAddress()
    {
        return clientRemoteAddress;
    }

    /**
     * Modifier for the 'clientRemoteAddress' attribute.
     *
     * @param clientRemoteAddress the new clientRemoteAddress value to set
     */
    public void setClientRemoteAddress(String clientRemoteAddress)
    {
        this.clientRemoteAddress = clientRemoteAddress;
    }

    /**
     * Inspector for the 'eventID' attribute.
     *
     * @return the eventID value
     */
    public String getEventID()
    {
        return eventID;
    }

    /**
     * Modifier for the 'eventID' attribute.
     *
     * @param eventID the new eventID value to set
     */
    public void setEventID(String eventID)
    {
        this.eventID = eventID;
    }

    /**
     * Inspector for the 'requestDump' attribute.
     *
     * @return the requestDump value
     */
    public String getRequestDump()
    {
        return requestDump;
    }

    /**
     * Modifier for the 'requestDump' attribute.
     *
     * @param requestDump the new requestDump value to set
     */
    public void setRequestDump(String requestDump)
    {
        this.requestDump = requestDump;
    }

    /**
     * Inspector for the 'requestType' attribute.
     *
     * @return the requestType value
     */
    public Character getRequestType()
    {
        return requestType;
    }

    /**
     * Modifier for the 'requestType' attribute.
     *
     * @param requestType the new requestType value to set
     */
    public void setRequestType(Character requestType)
    {
        this.requestType = requestType;
    }

    /**
     * Inspector for the 'serviceID' attribute.
     *
     * @return the serviceID value
     */
    public String getServiceID()
    {
        return serviceID;
    }

    /**
     * Modifier for the 'serviceID' attribute.
     *
     * @param serviceID the new serviceID value to set
     */
    public void setServiceID(String serviceID)
    {
        this.serviceID = serviceID;
    }

    /**
     * Inspector for the 'stageID' attribute.
     *
     * @return the stageID value
     */
    public String getStageID()
    {
        return stageID;
    }

    /**
     * Modifier for the 'stageID' attribute.
     *
     * @param stageID the new stageID value to set
     */
    public void setStageID(String stageID)
    {
        this.stageID = stageID;
    }

    /**
     * Inspector for the 'userID' attribute.
     *
     * @return the userID value
     */
    public String getUserID()
    {
        return userID;
    }

    /**
     * Modifier for the 'userID' attribute.
     *
     * @param userID the new userID value to set
     */
    public void setUserID(String userID)
    {
        this.userID = userID;
    }
}
