/**
 * 2009, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */

package pt.digitalis.dif.utils.logging.performance;

import pt.digitalis.dif.ioc.DIFIoCRegistry;
import pt.digitalis.utils.config.IConfigurations;
import pt.digitalis.utils.config.annotations.ConfigAlias;
import pt.digitalis.utils.config.annotations.ConfigDefault;
import pt.digitalis.utils.config.annotations.ConfigID;
import pt.digitalis.utils.config.annotations.ConfigIgnore;
import pt.digitalis.utils.config.annotations.ConfigSectionID;
import pt.digitalis.utils.config.annotations.ConfigVirtualPathForNode;

/**
 * Configuration point for the Performacne Logger feature
 *
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a><br/>
 * @created Sep 24, 2009
 */
@ConfigID("dif2")
@ConfigSectionID("PerformanceLogger")
@ConfigVirtualPathForNode("dif2/Logs/Performance")
public class PerformanceLoggerConfiguration
{

    /**
     * The singleton instance
     */
    static private PerformanceLoggerConfiguration instance = null;

    /**
     * if T will activate the audit of all stage requests to the DIF controller
     */
    private Boolean auditRequests;

    /**
     * The Audit requests purge max age.
     */
    private Long auditRequestsPurgeMaxDays;

    /**
     * The Audit requests purge max entries.
     */
    private Long auditRequestsPurgeMaxEntries;

    /**
     * if T will activate debug for the audit. Registers the dif context for every request!
     */
    private Boolean auditRequestsDebugMode;

    /**
     * if T will log slow database requests with INFO level
     */
    private Boolean logSlowDatabaseRequests;

    /**
     * if T will log slow requests with INFO level
     */
    private Boolean logSlowRequests;

    /**
     * The mim in milisecs to log
     */
    private Long logSlowRequestsFromDurationInMilisecs;

    /**
     * the slow request time
     */
    private Long logSlowRequestsTimeInSeconds;

    /**
     * If T will activate the tracking of database request execution times
     */
    private Boolean trackDatabaseRequests;

    /**
     * If T will activate the tracking of request execution times
     */
    private Boolean trackRequests;

    /**
     * Returns the active configuration object instance.
     *
     * @return the configuration instance
     */
    @ConfigIgnore
    static public PerformanceLoggerConfiguration getInstance()
    {
        if (instance == null)
            try
            {
                instance = DIFIoCRegistry.getRegistry().getImplementation(IConfigurations.class)
                        .readConfiguration(PerformanceLoggerConfiguration.class);
            }
            catch (Exception e)
            {
                instance = null;
            }

        return instance;
    }

    /**
     * Gets the log slow database requests if initialized.<br/>
     * When this configuration has not been initialized will not trigger it's initialization, since that can trigger a
     * stack overflow as the initialization may call the DataSet API if it is database based and that API will inspact
     * the DebugModel property
     *
     * @return the log slow database requests if initialized
     */
    @ConfigIgnore
    static public boolean getLogSlowDatabaseRequestsIfInitialized()
    {
        if (instance == null)
            return false;
        else
            return getInstance().getLogSlowDatabaseRequests();
    }

    /**
     * Inspector for the 'trackDatabaseRequests' attribute.<br/>
     * When this configuration has not been initialized will not trigger it's initialization, since that can trigger a
     * stack overflow as the initialization may call the DataSet API if it is database based and that API will inspact
     * the DebugModel property
     *
     * @return the trackDatabaseRequests value
     */
    @ConfigIgnore
    public static Boolean getTrackDatabaseRequestsIfInitialized()
    {
        if (instance == null)
            return false;
        else
            return getInstance().getTrackDatabaseRequests();
    }

    /**
     * Inspector for the 'auditRequests' attribute.
     *
     * @return the auditRequests value
     */
    @ConfigDefault("false")
    public Boolean getAuditRequests()
    {
        return auditRequests;
    }

    /**
     * Modifier for the 'auditRequests' attribute.
     *
     * @param auditRequests the new auditRequests value to set
     */
    public void setAuditRequests(Boolean auditRequests)
    {
        this.auditRequests = auditRequests;
    }

    /**
     * Inspector for the 'auditRequestsDebugMode' attribute.
     *
     * @return the auditRequestsDebugMode value
     */
    @ConfigDefault("false")
    public Boolean getAuditRequestsDebugMode()
    {
        return auditRequestsDebugMode;
    }

    /**
     * Modifier for the 'auditRequestsDebugMode' attribute.
     *
     * @param auditRequestsDebugMode the new auditRequestsDebugMode value to set
     */
    public void setAuditRequestsDebugMode(Boolean auditRequestsDebugMode)
    {
        this.auditRequestsDebugMode = auditRequestsDebugMode;
    }

    /**
     * Gets audit requests purge max age.
     *
     * @return the audit requests purge max age
     */
    @ConfigDefault("180")
    @ConfigAlias(name = "Audit Requests (purge after max age reached)",
            description = "The maximum age in days of entries to keep. When it is reached a purge will begin deleting older entries a block at a time until the max limit is reached.")
    public Long getAuditRequestsPurgeMaxDays()
    {
        return auditRequestsPurgeMaxDays;
    }

    /**
     * Sets audit requests purge max age.
     *
     * @param auditRequestsPurgeMaxDays the audit requests purge max age
     */
    public void setAuditRequestsPurgeMaxDays(Long auditRequestsPurgeMaxDays)
    {
        this.auditRequestsPurgeMaxDays = auditRequestsPurgeMaxDays;
    }

    /**
     * Gets audit requests purge max entries.
     *
     * @return the audit requests purge max entries
     */
    @ConfigDefault("1000000")
    @ConfigAlias(name = "Audit Requests (purge after max entries reached)",
            description = "The maximum number of entries to keep. When it is reached a purge will begin deleting older entries a block at a time until the max limit is reached.")
    public Long getAuditRequestsPurgeMaxEntries()
    {
        return auditRequestsPurgeMaxEntries;
    }

    /**
     * Sets audit requests purge max entries.
     *
     * @param auditRequestsPurgeMaxEntries the audit requests purge max entries
     */
    public void setAuditRequestsPurgeMaxEntries(Long auditRequestsPurgeMaxEntries)
    {
        this.auditRequestsPurgeMaxEntries = auditRequestsPurgeMaxEntries;
    }

    /**
     * Inspector for the 'logSlowDatabaseRequests' attribute.
     *
     * @return the logSlowDatabaseRequests value
     */
    @ConfigDefault("true")
    public Boolean getLogSlowDatabaseRequests()
    {
        return logSlowDatabaseRequests;
    }

    /**
     * Modifier for the 'logSlowDatabaseRequests' attribute.
     *
     * @param logSlowDatabaseRequests the new logSlowDatabaseRequests value to set
     */
    public void setLogSlowDatabaseRequests(Boolean logSlowDatabaseRequests)
    {
        this.logSlowDatabaseRequests = logSlowDatabaseRequests;
    }

    /**
     * Inspector for the 'logSlowRequests' attribute.
     *
     * @return the logSlowRequests value
     */
    @ConfigDefault("true")
    public Boolean getLogSlowRequests()
    {
        return logSlowRequests;
    }

    /**
     * Modifier for the 'logSlowRequests' attribute.
     *
     * @param logSlowRequests the new logSlowRequests value to set
     */
    public void setLogSlowRequests(Boolean logSlowRequests)
    {
        this.logSlowRequests = logSlowRequests;
    }

    /**
     * Inspector for the 'logSlowRequestsFromDurationInMilisecs' attribute.
     *
     * @return the logSlowRequestsFromDurationInMilisecs value
     */
    @ConfigDefault("200")
    public Long getLogSlowRequestsFromDurationInMilisecs()
    {
        return logSlowRequestsFromDurationInMilisecs;
    }

    /**
     * Modifier for the 'logSlowRequestsFromDurationInMilisecs' attribute.
     *
     * @param logSlowRequestsFromDurationInMilisecs the new logSlowRequestsFromDurationInMilisecs value to set
     */
    public void setLogSlowRequestsFromDurationInMilisecs(Long logSlowRequestsFromDurationInMilisecs)
    {
        this.logSlowRequestsFromDurationInMilisecs = logSlowRequestsFromDurationInMilisecs;
    }

    /**
     * Inspector for the 'logSlowRequestsTimeInSecods' attribute.
     *
     * @return the logSlowRequestsTimeInSecods value
     */
    @ConfigDefault("10")
    public Long getLogSlowRequestsTimeInSecods()
    {
        return logSlowRequestsTimeInSeconds;
    }

    /**
     * Modifier for the 'logSlowRequestsTimeInSecods' attribute.
     *
     * @param logSlowRequestsTimeInSecods the new logSlowRequestsTimeInSecods value to set
     */
    public void setLogSlowRequestsTimeInSecods(Long logSlowRequestsTimeInSecods)
    {
        this.logSlowRequestsTimeInSeconds = logSlowRequestsTimeInSecods;
    }

    /**
     * Inspector for the 'trackDatabaseRequests' attribute.
     *
     * @return the trackDatabaseRequests value
     */
    @ConfigDefault("true")
    public Boolean getTrackDatabaseRequests()
    {
        return trackDatabaseRequests;
    }

    /**
     * Modifier for the 'trackDatabaseRequests' attribute.
     *
     * @param trackDatabaseRequests the new trackDatabaseRequests value to set
     */
    public void setTrackDatabaseRequests(Boolean trackDatabaseRequests)
    {
        this.trackDatabaseRequests = trackDatabaseRequests;
    }

    /**
     * Inspector for the 'trackRequests' attribute.
     *
     * @return the trackRequests value
     */
    @ConfigDefault("true")
    public Boolean getTrackRequests()
    {
        return trackRequests;
    }

    /**
     * Modifier for the 'trackRequests' attribute.
     *
     * @param trackRequests the new trackRequests value to set
     */
    public void setTrackRequests(Boolean trackRequests)
    {
        this.trackRequests = trackRequests;
    }
}
