/**
 * 2016, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */

package pt.digitalis.dif.utils.logging.performance;

/**
 * Stage request entry to tracj number and timing of executions
 *
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a><br/>
 * @created 22/08/2016
 */
public class StageRequestEntry implements Comparable<StageRequestEntry>
{

    /**
     *
     */
    private String eventID;

    /**
     *
     */
    private String stageID;

    /**
     *
     */
    private Long totalExecutions = 0L;

    /**
     *
     */
    private Long totalExecutionTimeSpent = 0L;

    /**
     * Default constructor
     *
     * @param eventID
     * @param stageID
     */
    public StageRequestEntry(String stageID, String eventID)
    {
        this.stageID = stageID;
        this.eventID = eventID;
    }

    /**
     * Adds a new execution to the execution counter and increments the overall time spent
     *
     * @param timeSpent
     */
    public void addExecution(Long timeSpent)
    {
        this.totalExecutions++;
        this.totalExecutionTimeSpent += timeSpent;
    }

    /**
     * @see java.lang.Comparable#compareTo(java.lang.Object)
     */
    public int compareTo(StageRequestEntry another)
    {
        if (this.getTotalExecutionTimeSpent() < another.getTotalExecutionTimeSpent())
        {
            return -1;
        }
        else
        {
            return 1;
        }
    }

    /**
     * Calculates the average execution time
     *
     * @return the totalExecutionTimeSpent value
     */
    public Long getAverageExecutionTime()
    {
        if (this.totalExecutions == 0)
            return 0L;
        else
            return this.getTotalExecutionTimeSpent() / this.getTotalExecutions();
    }

    /**
     * Inspector for the 'eventID' attribute.
     *
     * @return the eventID value
     */
    public String getEventID()
    {
        return eventID;
    }

    /**
     * Modifier for the 'eventID' attribute.
     *
     * @param eventID the new eventID value to set
     */
    public void setEventID(String eventID)
    {
        this.eventID = eventID;
    }

    /**
     * Calculates a unique ID to identify thie stage/event call
     *
     * @return the totalExecutionTimeSpent value
     */
    public String getId()
    {
        if (this.eventID == null)
            return this.stageID;
        else
            return stageID + ":" + eventID;
    }

    /**
     * Inspector for the 'stageID' attribute.
     *
     * @return the stageID value
     */
    public String getStageID()
    {
        return stageID;
    }

    /**
     * Modifier for the 'stageID' attribute.
     *
     * @param stageID the new stageID value to set
     */
    public void setStageID(String stageID)
    {
        this.stageID = stageID;
    }

    /**
     * Inspector for the 'totalExecutionTimeSpent' attribute.
     *
     * @return the totalExecutionTimeSpent value
     */
    public Long getTotalExecutionTimeSpent()
    {
        return totalExecutionTimeSpent;
    }

    /**
     * Modifier for the 'totalExecutionTimeSpent' attribute.
     *
     * @param totalExecutionTimeSpent the new totalExecutionTimeSpent value to set
     */
    public void setTotalExecutionTimeSpent(Long totalExecutionTimeSpent)
    {
        this.totalExecutionTimeSpent = totalExecutionTimeSpent;
    }

    /**
     * Inspector for the 'totalExecutions' attribute.
     *
     * @return the totalExecutions value
     */
    public Long getTotalExecutions()
    {
        return totalExecutions;
    }

    /**
     * Modifier for the 'totalExecutions' attribute.
     *
     * @param totalExecutions the new totalExecutions value to set
     */
    public void setTotalExecutions(Long totalExecutions)
    {
        this.totalExecutions = totalExecutions;
    }
}
