package pt.digitalis.dif.utils.mail;

import java.util.Map;

/**
 * @author Joo Galaio <a href="mailto:jgalaio@digitalis.pt">jgalaio@digitalis.pt</a><br/>
 * @created Dec 28, 2015
 */
public interface IMailActionBuilder
{

    /**
     * Build the {@link MailAction}
     *
     * @param parameters      the parameter map
     * @param processName     the process name
     * @param applicationName the application name
     * @param businessUser    the business user
     *
     * @return {@link MailAction}
     */
    public MailAction buildMailAction(Map<String, String> parameters, String processName, String applicationName,
            String businessUser);
}
