package pt.digitalis.dif.utils.mail;

import pt.digitalis.utils.config.ConfigurationException;
import pt.digitalis.utils.config.IConfigurations;
import pt.digitalis.utils.config.annotations.ConfigIgnore;

import java.util.Properties;

/**
 * @author Galaio da Silva <a href="mailto:jgalaio@digitalis.pt">jgalaio@digitalis.pt</a><br/>
 * @created May 24, 2012
 */
public interface IMailConfiguration
{

    /**
     * Gets the configurations.
     *
     * @return the configurations
     */
    public IConfigurations getConfigurations();

    /**
     * Modifier for the 'configurations' attribute.
     *
     * @param configurations the new configurations value to set
     */
    public void setConfigurations(IConfigurations configurations);

    /**
     * @return the current instance or a new one if it has been updated
     *
     * @exception ConfigurationException
     */
    public IMailConfiguration getCurrentInstance() throws ConfigurationException;

    /**
     * Inspector for the 'debugEnabled' attribute.
     *
     * @return the debugEnabled value
     */
    public String getDebugEnabled();

    /**
     * Modifier for the 'debugEnabled' attribute.
     *
     * @param debugEnabled the new debugEnabled value to set
     */
    public void setDebugEnabled(String debugEnabled);

    /**
     * Inspector for the 'defaultFromAddress' attribute.
     *
     * @return the defaultFromAddress value
     */
    public String getDefaultFromAddress();

    /**
     * Modifier for the 'defaultFromAddress' attribute.
     *
     * @param defaultFromAddress the new defaultFromAddress value to set
     */
    public void setDefaultFromAddress(String defaultFromAddress);

    /**
     * Get the encoding
     *
     * @return encoding
     */
    public String getEncoding();

    /**
     * Set the encoding
     *
     * @param encoding the encoding
     */
    public void setEncoding(String encoding);

    /**
     * Inspector for the 'executedActionsPurgeTime' attribute.
     *
     * @return the executedActionsPurgeTime value
     */
    public Long getExecutedActionsPurgeTime();

    /**
     * Modifier for the 'executedActionsPurgeTime' attribute.
     *
     * @param executedActionsPurgeTime the new executedActionsPurgeTime value to set
     */
    public void setExecutedActionsPurgeTime(Long executedActionsPurgeTime);

    /**
     * Expiration Monitor sweep interval
     *
     * @return expirationMonitorInterval
     */
    public Long getExpirationMonitorInterval();

    /**
     * Set the expiration Monitor interval
     *
     * @param expirationMonitorInterval the expiration monitor interval
     */
    public void setExpirationMonitorInterval(Long expirationMonitorInterval);

    /**
     * Inspector for the 'expirationTime' attribute.
     *
     * @return the expirationTime value
     */

    public Long getExpirationTime();

    /**
     * Modifier for the 'expirationTime' attribute.
     *
     * @param expirationTime the new expirationTime value to set
     */
    public void setExpirationTime(Long expirationTime);

    /**
     * Inspector for the 'expiredActionsPurgeTime' attribute.
     *
     * @return the expiredActionsPurgeTime value
     */
    public Long getExpiredActionsPurgeTime();

    /**
     * Modifier for the 'expiredActionsPurgeTime' attribute.
     *
     * @param expiredActionsPurgeTime the new expiredActionsPurgeTime value to set
     */
    public void setExpiredActionsPurgeTime(Long expiredActionsPurgeTime);

    /**
     * Inspector for the 'GapBetweenMails' attribute.
     *
     * @return the gapBetweenMails value
     */
    public int getGapBetweenMails();

    /**
     * Modifier for the 'GapBetweenMails' attribute.
     *
     * @param gapBetweenMails the new gapBetweenMails value to set
     */
    public void setGapBetweenMails(int gapBetweenMails);

    /**
     * Inspector for the 'inExecutionActionsFailTime' attribute.
     *
     * @return the inExecutionActionsFailTime value
     */
    public Long getInExecutionActionsFailTime();

    /**
     * Modifier for the 'inExecutionActionsFailTime' attribute.
     *
     * @param inExecutionActionsFailTime the new inExecutionActionsFailTime value to set
     */
    public void setInExecutionActionsFailTime(Long inExecutionActionsFailTime);

    /**
     * Inspector for the 'LimitMaxEmails' attribute.
     *
     * @return the limitMaxEmails value
     */
    public int getLimitMaxEmails();

    /**
     * Modifier for the 'LimitMaxEmails' attribute.
     *
     * @param limitMaxEmails the new limitMaxEmails value to set
     */
    public void setLimitMaxEmails(int limitMaxEmails);

    /**
     * Inspector for the 'LimitTimeInterval' attribute.
     *
     * @return the limitTimeInterval value
     */
    public int getLimitTimeInterval();

    /**
     * Modifier for the 'LimitTimeInterval' attribute.
     *
     * @param limitTimeInterval the new limitTimeInterval value to set
     */
    public void setLimitTimeInterval(int limitTimeInterval);

    /**
     * Inspector for the 'mailServer' attribute.
     *
     * @return the mailServer value
     */
    public String getMailServer();

    /**
     * Modifier for the 'mailServer' attribute.
     *
     * @param mailServer the new mailServer value to set
     */
    public void setMailServer(String mailServer);

    /**
     * Inspector for the 'mailServerPassword' attribute.
     *
     * @return the mailServerPassword value
     */
    public String getMailServerPassword();

    /**
     * Modifier for the 'mailServerPassword' attribute.
     *
     * @param mailServerPassword the new mailServerPassword value to set
     */
    public void setMailServerPassword(String mailServerPassword);

    /**
     * Inspector for the 'mailServerPort' attribute.
     *
     * @return the mailServerPort value
     */
    public int getMailServerPort();

    /**
     * Modifier for the 'mailServerPort' attribute.
     *
     * @param mailServerPort the new mailServerPort value to set
     */
    public void setMailServerPort(int mailServerPort);

    /**
     * Inspector for the 'mailServerUsername' attribute.
     *
     * @return the mailServerUsername value
     */
    public String getMailServerUsername();

    /**
     * Modifier for the 'mailServerUsername' attribute.
     *
     * @param mailServerUsername the new mailServerUsername value to set
     */
    public void setMailServerUsername(String mailServerUsername);

    /**
     * Inspector for the 'maxAttemptsUntilFail' attribute.
     *
     * @return the maxAttemptsUntilFail value
     */
    public Long getMaxAttemptsUntilFail();

    /**
     * Modifier for the 'maxAttemptsUntilFail' attribute.
     *
     * @param maxAttemptsUntilFail the new maxAttemptsUntilFail value to set
     */
    public void setMaxAttemptsUntilFail(Long maxAttemptsUntilFail);

    /**
     * Inspector for the 'maxAttemptsWaitTimeBetweenAttempts' attribute.
     *
     * @return the maxAttemptsWaitTimeBetweenAttempts value
     */
    public Long getMaxAttemptsWaitTimeBetweenAttempts();

    /**
     * Inspector for the 'originalConfs' attribute.
     *
     * @return the originalConfs value
     */
    @ConfigIgnore
    public Properties getOriginalConfs();

    /**
     * Modifier for the 'originalConfs' attribute.
     *
     * @param originalConfs the new originalConfs value to set
     */
    public void setOriginalConfs(Properties originalConfs);

    /**
     * Inspector for the 'useSSL' attribute.
     *
     * @return the useSSL value
     */
    public Boolean getUseSSL();

    /**
     * Modifier for the 'useSSL' attribute.
     *
     * @param useSSL the new useSSL value to set
     */
    public void setUseSSL(Boolean useSSL);

    /**
     * Write configuration
     *
     * @exception Exception if an Exception occurrs
     */
    public void writeConfiguration() throws Exception;
}
