package pt.digitalis.dif.utils.mail;

import pt.digitalis.dif.ioc.DIFIoCRegistry;
import pt.digitalis.utils.config.ConfigurationException;
import pt.digitalis.utils.config.ConfigurationsProvider;
import pt.digitalis.utils.config.IConfigurations;
import pt.digitalis.utils.config.annotations.ConfigDefault;
import pt.digitalis.utils.config.annotations.ConfigID;
import pt.digitalis.utils.config.annotations.ConfigIgnore;
import pt.digitalis.utils.config.annotations.ConfigSectionID;

import java.util.Properties;

/**
 * @author Galaio da Silva <a href="mailto:jgalaio@digitalis.pt">jgalaio@digitalis.pt</a><br/>
 * @created May 24, 2012
 */
@ConfigID(MailConfiguration.CONFIG_ID)
@ConfigSectionID(MailConfiguration.CONFIG_SECTION_ID)
public class MailConfiguration implements IMailConfiguration
{

    /** The Constant CONFIG_ID. */
    public static final String CONFIG_ID = "Digi Utils";

    /** The Constant CONFIG_SECTION_ID. */
    public static final String CONFIG_SECTION_ID = "mail";

    /** the singleton instance. */
    private static MailConfiguration instance = null;

    /** The configuration manager instance. */
    private IConfigurations configurations;

    /** Determines if the debug is enabled. */
    private String debugEnabled;

    /** The default from ail address. */
    private String defaultFromAddress;

    /** The charater encoding */
    private String encoding;

    /** the time that must elapse for a given Executed action to be purged from the pool, in seconds */
    private Long executedActionsPurgeTime; // 2 hours

    /** The expiration monitor sweep interval */
    private Long expirationMonitorInterval;

    /** the time that must elapse for a given action to become Expired, in seconds */
    private Long expirationTime; // 3 days

    /** the time that must elapse for a given Expired action to be purged from the pool, in seconds */
    private Long expiredActionsPurgeTime; // 2 hours

    /** The Gab Between Mails */
    private int gapBetweenMails;

    /** the time that must elapse for a given In Execution action to be considered as failed, in seconds */
    private Long inExecutionActionsFailTime; // 2 hours

    /** The Limit Max Emails */
    private int limitMaxEmails;

    /** The Limit Time Interval */
    private int limitTimeInterval;

    /** The mail server. */
    private String mailServer;

    /** The mail server security password. */
    private String mailServerPassword;

    /** The mail server port. */
    private int mailServerPort;

    /** The mail server security username. */
    private String mailServerUsername;

    /** the total attempts before assuming the mail cannot be sent (prevent intermittent communication fails) */
    private Long maxAttemptsUntilFail;

    /** the time it waits between each attempt */
    private Long maxAttemptsWaitTimeBetweenAttempts;

    /** The original confs. */
    private Properties originalConfs = null;

    /** The use ssl. */
    private Boolean useSSL;

    /**
     * MailConfiguration Construtor
     */
    public MailConfiguration()
    {

    }

    /**
     * @return {@link MailConfiguration}
     *
     * @exception ConfigurationException
     */
    @ConfigIgnore
    public static IMailConfiguration getInstance() throws ConfigurationException
    {
        if (instance == null)
        {
            instance = ConfigurationsProvider.getConfigurations().readConfiguration(MailConfiguration.class);
            instance.setOriginalConfs(instance.getConfigurations().readConfiguration(CONFIG_ID, CONFIG_SECTION_ID));
        }
        return instance;
    }

    /**
     * Gets the configurations.
     *
     * @return the configurations
     */
    @Override
    @ConfigIgnore
    public IConfigurations getConfigurations()
    {

        if (configurations == null)
            configurations = DIFIoCRegistry.getRegistry().getImplementation(IConfigurations.class);

        return configurations;
    }

    /**
     * Modifier for the 'configurations' attribute.
     *
     * @param configurations the new configurations value to set
     */
    @Override
    public void setConfigurations(IConfigurations configurations)
    {
        this.configurations = configurations;
    }

    /**
     * @see pt.digitalis.dif.utils.mail.IMailConfiguration#getCurrentInstance()
     */
    @Override
    @ConfigIgnore
    public IMailConfiguration getCurrentInstance() throws ConfigurationException
    {
        return MailConfiguration.getInstance();
    }

    /**
     * Inspector for the 'debugEnabled' attribute.
     *
     * @return the debugEnabled value
     */
    @Override
    @ConfigDefault("false")
    public String getDebugEnabled()
    {
        return debugEnabled;
    }

    /**
     * Modifier for the 'debugEnabled' attribute.
     *
     * @param debugEnabled the new debugEnabled value to set
     */
    @Override
    public void setDebugEnabled(String debugEnabled)
    {
        this.debugEnabled = debugEnabled;
    }

    /**
     * Inspector for the 'defaultFromAddress' attribute.
     *
     * @return the defaultFromAddress value
     */
    @Override
    @ConfigDefault("no-reply@company.com")
    public String getDefaultFromAddress()
    {
        return defaultFromAddress;
    }

    /**
     * Modifier for the 'defaultFromAddress' attribute.
     *
     * @param defaultFromAddress the new defaultFromAddress value to set
     */
    @Override
    public void setDefaultFromAddress(String defaultFromAddress)
    {
        this.defaultFromAddress = defaultFromAddress;
    }

    /**
     * Inspector for the 'enconding' attribute.
     *
     * @return the enconding value
     */
    @Override
    @ConfigDefault("ISO-8859-1")
    public String getEncoding()
    {
        return encoding;
    }

    /**
     * Modifier for the 'enconding' attribute.
     *
     * @param enconding the new enconding value to set
     */
    @Override
    public void setEncoding(String enconding)
    {
        this.encoding = enconding;
    }

    /**
     * Inspector for the 'executedActionsPurgeTime' attribute.
     *
     * @return the executedActionsPurgeTime value
     */
    @Override
    @ConfigDefault("259200")
    public Long getExecutedActionsPurgeTime()
    {
        return executedActionsPurgeTime;
    }

    /**
     * Modifier for the 'executedActionsPurgeTime' attribute.
     *
     * @param executedActionsPurgeTime the new executedActionsPurgeTime value to set
     */
    @Override
    public void setExecutedActionsPurgeTime(Long executedActionsPurgeTime)
    {
        this.executedActionsPurgeTime = executedActionsPurgeTime;
    }

    /**
     * @see pt.digitalis.dif.utils.mail.IMailConfiguration#getExpirationMonitorInterval()
     */
    @Override
    @ConfigDefault("300000")
    public Long getExpirationMonitorInterval()
    {
        return expirationMonitorInterval;
    }

    /**
     * @see pt.digitalis.dif.utils.mail.IMailConfiguration#setExpirationMonitorInterval(java.lang.Long)
     */
    @Override
    public void setExpirationMonitorInterval(Long expirationMonitorInterval)
    {
        this.expirationMonitorInterval = expirationMonitorInterval;
    }

    /**
     * Inspector for the 'expirationTime' attribute.
     *
     * @return the expirationTime value
     */
    @Override
    @ConfigDefault("259200")
    public Long getExpirationTime()
    {
        return expirationTime;
    }

    /**
     * Modifier for the 'expirationTime' attribute.
     *
     * @param expirationTime the new expirationTime value to set
     */
    @Override
    public void setExpirationTime(Long expirationTime)
    {
        this.expirationTime = expirationTime;
    }

    /**
     * Inspector for the 'expiredActionsPurgeTime' attribute.
     *
     * @return the expiredActionsPurgeTime value
     */
    @Override
    @ConfigDefault("259200")
    public Long getExpiredActionsPurgeTime()
    {
        return expiredActionsPurgeTime;
    }

    /**
     * Modifier for the 'expiredActionsPurgeTime' attribute.
     *
     * @param expiredActionsPurgeTime the new expiredActionsPurgeTime value to set
     */
    @Override
    public void setExpiredActionsPurgeTime(Long expiredActionsPurgeTime)
    {
        this.expiredActionsPurgeTime = expiredActionsPurgeTime;
    }

    /**
     * Inspector for the 'GapBetweenMails' attribute.
     *
     * @return the gapBetweenMails value
     */
    @Override
    @ConfigDefault("0")
    public int getGapBetweenMails()
    {
        return gapBetweenMails;
    }

    /**
     * Modifier for the 'GapBetweenMails' attribute.
     *
     * @param gapBetweenMails the new gapBetweenMails value to set
     */
    @Override
    public void setGapBetweenMails(int gapBetweenMails)
    {
        this.gapBetweenMails = gapBetweenMails;
    }

    /**
     * Inspector for the 'inExecutionActionsFailTime' attribute.
     *
     * @return the inExecutionActionsFailTime value
     */
    @Override
    @ConfigDefault("7200")
    public Long getInExecutionActionsFailTime()
    {
        return inExecutionActionsFailTime;
    }

    /**
     * Modifier for the 'inExecutionActionsFailTime' attribute.
     *
     * @param inExecutionActionsFailTime the new inExecutionActionsFailTime value to set
     */
    @Override
    public void setInExecutionActionsFailTime(Long inExecutionActionsFailTime)
    {
        this.inExecutionActionsFailTime = inExecutionActionsFailTime;
    }

    /**
     * Inspector for the 'LimitMaxEmails' attribute.
     *
     * @return the limitMaxEmails value
     */
    @Override
    @ConfigDefault("0")
    public int getLimitMaxEmails()
    {
        return limitMaxEmails;
    }

    /**
     * Modifier for the 'LimitMaxEmails' attribute.
     *
     * @param limitMaxEmails the new limitMaxEmails value to set
     */
    @Override
    public void setLimitMaxEmails(int limitMaxEmails)
    {
        this.limitMaxEmails = limitMaxEmails;
    }

    /**
     * Inspector for the 'LimitTimeInterval' attribute.
     *
     * @return the limitTimeInterval value
     */
    @Override
    @ConfigDefault("0")
    public int getLimitTimeInterval()
    {
        return limitTimeInterval;
    }

    /**
     * Modifier for the 'LimitTimeInterval' attribute.
     *
     * @param limitTimeInterval the new limitTimeInterval value to set
     */
    @Override
    public void setLimitTimeInterval(int limitTimeInterval)
    {
        this.limitTimeInterval = limitTimeInterval;
    }

    /**
     * Inspector for the 'mailServer' attribute.
     *
     * @return the mailServer value
     */
    @Override
    @ConfigDefault("domino.digitalis.pt")
    public String getMailServer()
    {
        return mailServer;
    }

    /**
     * Modifier for the 'mailServer' attribute.
     *
     * @param mailServer the new mailServer value to set
     */
    @Override
    public void setMailServer(String mailServer)
    {
        this.mailServer = mailServer;
    }

    /**
     * Inspector for the 'mailServerPassword' attribute.
     *
     * @return the mailServerPassword value
     */
    @Override
    public String getMailServerPassword()
    {
        return mailServerPassword;
    }

    /**
     * Modifier for the 'mailServerPassword' attribute.
     *
     * @param mailServerPassword the new mailServerPassword value to set
     */
    @Override
    public void setMailServerPassword(String mailServerPassword)
    {
        this.mailServerPassword = mailServerPassword;
    }

    /**
     * Inspector for the 'mailServerPort' attribute.
     *
     * @return the mailServerPort value
     */
    @Override
    public int getMailServerPort()
    {
        return mailServerPort;
    }

    /**
     * Modifier for the 'mailServerPort' attribute.
     *
     * @param mailServerPort the new mailServerPort value to set
     */
    @Override
    public void setMailServerPort(int mailServerPort)
    {
        this.mailServerPort = mailServerPort;
    }

    /**
     * Inspector for the 'mailServerUsername' attribute.
     *
     * @return the mailServerUsername value
     */
    @Override
    public String getMailServerUsername()
    {
        return mailServerUsername;
    }

    /**
     * Modifier for the 'mailServerUsername' attribute.
     *
     * @param mailServerUsername the new mailServerUsername value to set
     */
    @Override
    public void setMailServerUsername(String mailServerUsername)
    {
        this.mailServerUsername = mailServerUsername;
    }

    /**
     * Inspector for the 'maxAttemptsUntilFail' attribute.
     *
     * @return the maxAttemptsUntilFail value
     */
    @Override
    @ConfigDefault("5")
    public Long getMaxAttemptsUntilFail()
    {
        return maxAttemptsUntilFail;
    }

    /**
     * Modifier for the 'maxAttemptsUntilFail' attribute.
     *
     * @param maxAttemptsUntilFail the new maxAttemptsUntilFail value to set
     */
    @Override
    public void setMaxAttemptsUntilFail(Long maxAttemptsUntilFail)
    {
        this.maxAttemptsUntilFail = maxAttemptsUntilFail;
    }

    /**
     * Inspector for the 'maxAttemptsWaitTimeBetweenAttempts' attribute.
     *
     * @return the maxAttemptsWaitTimeBetweenAttempts value
     */
    @Override
    @ConfigDefault("5000")
    public Long getMaxAttemptsWaitTimeBetweenAttempts()
    {
        return maxAttemptsWaitTimeBetweenAttempts;
    }

    /**
     * Modifier for the 'maxAttemptsWaitTimeBetweenAttempts' attribute.
     *
     * @param maxAttemptsWaitTimeBetweenAttempts the new maxAttemptsWaitTimeBetweenAttempts value to set
     */
    public void setMaxAttemptsWaitTimeBetweenAttempts(Long maxAttemptsWaitTimeBetweenAttempts)
    {
        this.maxAttemptsWaitTimeBetweenAttempts = maxAttemptsWaitTimeBetweenAttempts;
    }

    /**
     * Inspector for the 'originalConfs' attribute.
     *
     * @return the originalConfs value
     */
    @Override
    @ConfigIgnore
    public Properties getOriginalConfs()
    {
        return originalConfs;
    }

    /**
     * Modifier for the 'originalConfs' attribute.
     *
     * @param originalConfs the new originalConfs value to set
     */
    @Override
    public void setOriginalConfs(Properties originalConfs)
    {
        this.originalConfs = originalConfs;
    }

    /**
     * Inspector for the 'useSSL' attribute.
     *
     * @return the useSSL value
     */
    @Override
    @ConfigDefault("false")
    public Boolean getUseSSL()
    {
        return useSSL;
    }

    /**
     * Modifier for the 'useSSL' attribute.
     *
     * @param useSSL the new useSSL value to set
     */
    @Override
    public void setUseSSL(Boolean useSSL)
    {
        this.useSSL = useSSL;
    }

    /**
     * Write configuration
     *
     * @exception Exception
     */
    @Override
    public void writeConfiguration() throws Exception
    {
        this.getConfigurations().writeConfiguration(this);
    }
}
