/**
 * 2011, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */

package pt.digitalis.dif.utils.monitor;

import com.newrelic.api.agent.NewRelic;
import pt.digitalis.dif.startup.DIFStartupConfiguration;
import pt.digitalis.dif.startup.NewRelicMonitorizationConfiguration;

/**
 * Serves as an abstraction to the monitoring agent in use. Presently New Relic. <br/>
 * All these calls will only be triggers when in developer or testing mode ({@link DIFStartupConfiguration}). *
 *
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a><br/>
 * @created 17 de Ago de 2012
 * @see "http://http://newrelic.com/"
 */
public class MonitorUtil
{

    /**
     * Adds a parameter to the current process for the monitoring agent
     *
     * @param key   the parameter key name
     * @param value the parameter value
     */
    static public void addParameter(String key, String value)
    {
        if (DIFStartupConfiguration.getDeveloperMode() || DIFStartupConfiguration.getTestingMode() ||
            NewRelicMonitorizationConfiguration.getInstance().getEnabled())
            NewRelic.addCustomParameter(key, value);
    }

    /**
     * @return the JavaScript contribution for the page footer
     */
    static public String getBrowserTimingFooter()
    {
        if (DIFStartupConfiguration.getDeveloperMode() || DIFStartupConfiguration.getTestingMode() ||
            NewRelicMonitorizationConfiguration.getInstance().getEnabled())
            return NewRelic.getBrowserTimingFooter();
        else
            return "";
    }

    /**
     * @return the JavaScript contribution for the page header
     */
    static public String getBrowserTimingHeader()
    {
        if (DIFStartupConfiguration.getDeveloperMode() || DIFStartupConfiguration.getTestingMode() ||
            NewRelicMonitorizationConfiguration.getInstance().getEnabled())
            return NewRelic.getBrowserTimingHeader();
        else
            return "";
    }
}
