/**
 * 2019, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 http://www.digitalis.pt
 */
package pt.digitalis.dif.utils.multithreading;

import pt.digitalis.dif.utils.logging.DIFLogger;
import pt.digitalis.utils.common.Chronometer;

import java.util.ArrayList;
import java.util.List;

/**
 * The Class MultiThreadlExecutor.
 *
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a><br/>
 * @created Sep 18, 2019
 */
public abstract class AbstractMultiThreadlExecutor implements IMultiThreadExecutor
{

    /** The crono. */
    private Chronometer crono;

    /** The errors. */
    private List<Exception> errors = new ArrayList<Exception>();

    /** The executer ID. */
    private String executerID;

    /** The id counter. */
    private long idCounter = 0;

    /** The running. */
    private boolean running = false;

    /**
     * Instantiates a new multi thread processing.
     *
     * @param executerID the executer ID
     */
    public AbstractMultiThreadlExecutor(String executerID)
    {
        this.executerID = executerID;

        crono = new Chronometer();
        crono.start();
        running = true;
    }

    /**
     * @see pt.digitalis.dif.utils.multithreading.IMultiThreadExecutor#getErrors()
     */
    public List<Exception> getErrors()
    {
        return errors;
    }

    /**
     * Sets the errors.
     *
     * @param errors the errors to set
     */
    void setErrors(List<Exception> errors)
    {
        this.errors = errors;
    }

    /**
     * @see pt.digitalis.dif.utils.multithreading.IMultiThreadExecutor#getExecuterID()
     */
    public String getExecuterID()
    {
        return executerID;
    }

    /**
     * @see pt.digitalis.dif.utils.multithreading.IMultiThreadExecutor#reportError(java.lang.Exception)
     */
    public void reportError(Exception exception)
    {
        this.errors.add(exception);
    }

    /**
     * Specific submit task.
     *
     * @param task the task
     */
    protected abstract void specificSubmitTask(TaskExecutor task);

    /**
     * Specific wait for tasks.
     *
     * @exception InterruptedException the interrupted exception
     */
    protected abstract void specificWaitForTasks() throws InterruptedException;

    /**
     * @see pt.digitalis.dif.utils.multithreading.IMultiThreadExecutor#submitTask(pt.digitalis.dif.utils.multithreading.TaskExecutor)
     */
    public void submitTask(TaskExecutor task)
    {
        if (!running)
        {
            crono.start();
            running = true;
        }

        task.setProcessorManager(this);
        task.setId(this.idCounter++);

        specificSubmitTask(task);
    }

    /**
     * @see pt.digitalis.dif.utils.multithreading.IMultiThreadExecutor#waitForAllThreadsToFinish()
     */
    public void waitForAllThreadsToFinish() throws InterruptedException
    {
        this.waitForAllThreadsToFinish(true);
    }

    /**
     * @see pt.digitalis.dif.utils.multithreading.IMultiThreadExecutor#waitForAllThreadsToFinish(boolean)
     */
    public void waitForAllThreadsToFinish(boolean reportRuntimeExceptionWithFirstExceptionReported)
            throws InterruptedException
    {
        specificWaitForTasks();

        crono.end();
        running = false;

        DIFLogger.getLogger().info("Multi thread executor #" + executerID + " finished execution in " +
                                   crono.getTimePassedAsFormattedString());

        if (reportRuntimeExceptionWithFirstExceptionReported && !errors.isEmpty())
            throw new RuntimeException(errors.get(0));
    }
}
