package pt.digitalis.dif.utils.multithreading;

import java.util.List;

/**
 * The Interface IMultiThreadExecutor.
 */
public interface IMultiThreadExecutor
{

    /**
     * Gets the errors.
     *
     * @return the errors
     */
    List<Exception> getErrors();

    /**
     * Gets the executer ID.
     *
     * @return the executerID
     */
    String getExecuterID();

    /**
     * Report error.
     *
     * @param exception the exception
     */
    void reportError(Exception exception);

    /**
     * Adds the thread but does not start it.
     *
     * @param task the task
     */
    void submitTask(TaskExecutor task);

    /**
     * Wait for all threads to finish.
     *
     * @exception InterruptedException the interrupted exception
     */
    void waitForAllThreadsToFinish() throws InterruptedException;

    /**
     * Wait for all threads to finish.
     *
     * @param reportRuntimeExceptionWithFirstExceptionReported the report runtime exception with first exception
     *                                                         reported
     *
     * @exception InterruptedException the interrupted exception
     */
    void waitForAllThreadsToFinish(boolean reportRuntimeExceptionWithFirstExceptionReported)
            throws InterruptedException;
}