/**
 * 2019, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 http://www.digitalis.pt
 */
package pt.digitalis.dif.utils.multithreading;

// TODO: Auto-generated Javadoc

/**
 * The Class MultiThreadExecuterUtils.
 *
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a><br/>
 * @created Sep 18, 2019
 */
public class MultiThreadExecuterUtils
{

    /**
     * New execution pool.
     *
     * @param executorID the executor ID
     *
     * @return the i multi thread executor
     */
    public static IMultiThreadExecutor newExecutionPool(String executorID)
    {
        // return new MultiThreadlExecutorConcurrentAPIImpl(executorID);
        return new MultiThreadlExecutorDirectThreadListImpl(executorID);
    }

    /**
     * New execution pool.
     *
     * @param executorID the executor ID
     * @param maxThreads the max threads
     *
     * @return the i multi thread executor
     */
    public static IMultiThreadExecutor newExecutionPool(String executorID, int maxThreads)
    {
        if (maxThreads == 1)
            return newSequencialExecutor(executorID);
        else
            return new MultiThreadlExecutorConcurrentAPIImpl(executorID, maxThreads);
    }

    /**
     * New sequencial executor.
     *
     * @param executorID the executor ID
     *
     * @return the i multi thread executor
     */
    public static IMultiThreadExecutor newSequencialExecutor(String executorID)
    {
        return new MultiThreadlExecutorConcurrentAPIImpl(executorID, 1);
    }
}
