package pt.digitalis.dif.utils.multithreading;

import pt.digitalis.dif.utils.logging.DIFLogger;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

/**
 * The Class MultiThreadlExecutorConcurrentAPIImpl.
 */
public class MultiThreadlExecutorConcurrentAPIImpl extends AbstractMultiThreadlExecutor
{

    /** The pool. */
    private ExecutorService pool;

    /**
     * Instantiates a new multi thread processing.
     *
     * @param executerID the executer ID
     */
    public MultiThreadlExecutorConcurrentAPIImpl(String executerID)
    {
        this(executerID, null);
    }

    /**
     * Instantiates a new multi thread processing.
     *
     * @param executerID the executer ID
     * @param maxThreads the max threads at the same time
     */
    public MultiThreadlExecutorConcurrentAPIImpl(String executerID, Integer maxThreads)
    {
        super(executerID);

        if (maxThreads == null)
            pool = Executors.newCachedThreadPool();
        else
            pool = Executors.newFixedThreadPool(maxThreads);

        DIFLogger.getLogger().debug("Multi thread executor #" + executerID + "(" +
                                    (maxThreads == null ? "unlimited " : "max: " + maxThreads) +
                                    " threads) initialized...");
    }

    /**
     * @see pt.digitalis.dif.utils.multithreading.AbstractMultiThreadlExecutor#specificSubmitTask(pt.digitalis.dif.utils.multithreading.TaskExecutor)
     */
    @Override
    protected void specificSubmitTask(TaskExecutor task)
    {
        this.pool.submit(task);
    }

    /**
     * @see pt.digitalis.dif.utils.multithreading.AbstractMultiThreadlExecutor#specificWaitForTasks()
     */
    @Override
    protected void specificWaitForTasks() throws InterruptedException
    {
        pool.shutdown();
        pool.awaitTermination(5, TimeUnit.MINUTES);
    }
}
