package pt.digitalis.dif.utils.multithreading;

import pt.digitalis.dif.utils.logging.DIFLogger;

import java.util.ArrayList;
import java.util.List;

/**
 * The Class MultiThreadlExecutorConcurrentAPIImpl.
 */
public class MultiThreadlExecutorDirectThreadListImpl extends AbstractMultiThreadlExecutor
{

    /** The threads. */
    private List<Thread> threads;

    /**
     * Instantiates a new multi thread processing.
     *
     * @param executerID the executer ID
     */
    public MultiThreadlExecutorDirectThreadListImpl(String executerID)
    {
        super(executerID);

        threads = new ArrayList<Thread>();

        DIFLogger.getLogger().debug("Multi thread executor #" + executerID + "(unlimited threads) initialized...");
    }

    /**
     * @see pt.digitalis.dif.utils.multithreading.AbstractMultiThreadlExecutor#specificSubmitTask(pt.digitalis.dif.utils.multithreading.TaskExecutor)
     */
    @Override
    protected void specificSubmitTask(TaskExecutor task)
    {
        Thread thread = new Thread(task);
        thread.start();
        this.threads.add(thread);
    }

    /**
     * @see pt.digitalis.dif.utils.multithreading.AbstractMultiThreadlExecutor#specificWaitForTasks()
     */
    @Override
    protected void specificWaitForTasks() throws InterruptedException
    {
        for (Thread thread : threads)
        {
            thread.join();
        }
    }
}
