/**
 * 2019, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 http://www.digitalis.pt
 */
package pt.digitalis.dif.utils.multithreading;

import pt.digitalis.dif.utils.logging.AuditContext;
import pt.digitalis.dif.utils.logging.DIFLogger;
import pt.digitalis.utils.common.Chronometer;

/**
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a><br/>
 * @created Sep 18, 2019
 */
public abstract class TaskExecutor implements Runnable
{

    /** The audit context process name. */
    private String auditContextProcessName = "DIFMultithreadedTask";

    /** The audit context user. */
    private String auditContextUser = "DIF";

    /** The id. */
    private Long id;

    /** The processor manager. */
    private IMultiThreadExecutor processorManager = null;

    /**
     * Execute logic.
     *
     * @exception Exception the exception
     */
    public abstract void executeLogic() throws Exception;

    /**
     * @return the id
     */
    public Long getId()
    {
        return id;
    }

    /**
     * @param id the id to set
     */
    public void setId(Long id)
    {
        this.id = id;
    }

    /**
     * @see java.lang.Runnable#run()
     */
    public void run()
    {
        AuditContext.setUserForCurrentThread(auditContextUser);
        AuditContext.setProcessNameForCurrentThread(auditContextProcessName);

        try
        {
            Chronometer crono = new Chronometer();
            crono.start();
            DIFLogger.getLogger()
                    .debug("Multi thread executor #" + processorManager.getExecuterID() + ": started task #" + id +
                           "...");

            executeLogic();
            crono.end();

            DIFLogger.getLogger()
                    .debug("Multi thread executor #" + processorManager.getExecuterID() + ": ended task #" + id +
                           " in " + crono.getTimePassedAsFormattedString());
        }
        catch (Exception exception)
        {
            if (processorManager != null)
                processorManager.reportError(exception);
        }
    }

    /**
     * @param auditContextProcessName the auditContextProcessName to set
     */
    public void setAuditContextProcessName(String auditContextProcessName)
    {
        this.auditContextProcessName = auditContextProcessName;
    }

    /**
     * @param auditContextUser the auditContextUser to set
     */
    public void setAuditContextUser(String auditContextUser)
    {
        this.auditContextUser = auditContextUser;
    }

    /**
     * @param processorManager the processorManager to set
     */
    public void setProcessorManager(IMultiThreadExecutor processorManager)
    {
        this.processorManager = processorManager;
    }
}
