package pt.digitalis.dif.dataintegration.events.publishers;

import pt.digitalis.dif.events.impl.EventsManager;
import pt.digitalis.dif.events.impl.publisher.AbstractEventPublisher;

/**
 * The type Di data set event publisher.
 */
public class DISetEventPublisher extends AbstractEventPublisher
{

    @Override
    public void declareCategories()
    {
        EventsManager.getInstance()
                .declareCategory(this, DISetEventCategory.DI_SET_AVAILABLE.getBusinessCategoryRepresentation());
    }

    /**
     * Gets application.
     *
     * @return the application
     */
    @Override
    public String getApplication()
    {
        return "DIF";
    }

    /**
     * Gets description.
     *
     * @return the description
     */
    @Override
    public String getDescription()
    {
        return getApplication() + ": Data Integration events";
    }

    /**
     * Gets id.
     *
     * @return the id
     */
    @Override
    public String getID()
    {
        return DISetEventPublisher.class.getSimpleName();
    }
}
