/**
 * - Digitalis Internal Framework v2.0 - (C) 2008, Digitalis Informatica. Distribuicao e Gestao de Informatica, Lda.
 * Estrada de Paco de Arcos num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999
 * http://www.digitalis.pt
 */
package pt.digitalis.dif.dataintegration.ioc;

import pt.digitalis.dif.dataintegration.events.publishers.DISetEventPublisher;
import pt.digitalis.dif.dataintegration.events.subscribers.DISetEventSubscriber;
import pt.digitalis.dif.events.api.IEventPublisher;
import pt.digitalis.dif.events.api.IEventSubscriber;
import pt.digitalis.utils.ioc.modules.IIoCModule;
import pt.digitalis.utils.ioc.modules.IoCBinder;

/**
 * Application Module.
 *
 * @author Pedro Viegas <a href="mailto:pviegas@digitlais.pt">pviegas@digitalis.pt</a>
 */
public class DataIntegrationManagerModule implements IIoCModule
{

    /**
     * @see IIoCModule#configure(IoCBinder)
     */
    @Override
    public void configure(IoCBinder binder)
    {
        // Bind event publishers
        binder.bind(IEventPublisher.class, DISetEventPublisher.class).asSingleton()
                .withId(DISetEventPublisher.class.getSimpleName());

        // Bind event subscribers
        binder.bind(IEventSubscriber.class, DISetEventSubscriber.class)
                .withId(DISetEventSubscriber.class.getSimpleName());
    }
}
