/*
 * Decompiled with CFR 0.152.
 */
package pt.digitalis.dif.dataintegration;

import java.lang.reflect.InvocationTargetException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.collections.map.CaseInsensitiveMap;
import org.hibernate.Session;
import pt.digitalis.dif.dataintegration.DataIntegrationFieldType;
import pt.digitalis.dif.dataintegration.events.publishers.DISetEventCategory;
import pt.digitalis.dif.dataintegration.events.publishers.DISetEventPublisher;
import pt.digitalis.dif.dataintegration.events.subscribers.DISetEventSubscriber;
import pt.digitalis.dif.dem.managers.impl.model.DIFRepositoryFactory;
import pt.digitalis.dif.dem.managers.impl.model.IDataIntegrationService;
import pt.digitalis.dif.dem.managers.impl.model.data.DataIntegrationField;
import pt.digitalis.dif.dem.managers.impl.model.data.DataIntegrationRecord;
import pt.digitalis.dif.dem.managers.impl.model.data.DataIntegrationSet;
import pt.digitalis.dif.events.api.IEventPublisher;
import pt.digitalis.dif.events.api.IEventSubscriber;
import pt.digitalis.dif.events.exceptions.EventException;
import pt.digitalis.dif.events.exceptions.EventSubscriptionExistsException;
import pt.digitalis.dif.events.impl.EventsManager;
import pt.digitalis.dif.ioc.DIFIoCRegistry;
import pt.digitalis.dif.model.dataset.DataSetException;
import pt.digitalis.dif.model.dataset.Query;
import pt.digitalis.dif.model.dataset.SortMode;
import pt.digitalis.dif.model.utils.AbstractBeanAttributes;
import pt.digitalis.dif.model.utils.AbstractBeanAttributesDefinition;
import pt.digitalis.utils.config.IConfigurations;

public class DataIntegrationManager {
    private static DataIntegrationManager instance = null;
    private static IDataIntegrationService dataIntegrationService = (IDataIntegrationService)DIFIoCRegistry.getRegistry().getImplementation(IDataIntegrationService.class);
    Map<Long, Map<String, DataIntegrationField>> fieldsByRootRecord = new CaseInsensitiveMap();
    private Long dataIntegrationSetId;
    private Map<Long, List<DataIntegrationField>> fieldsByRecord = null;

    public DataIntegrationManager(Long dataIntegrationSetId) {
        this.dataIntegrationSetId = dataIntegrationSetId;
    }

    public static DataIntegrationSet getMostRecentSet(String entityType, String entityId) throws DataSetException {
        Query query = dataIntegrationService.getDataIntegrationSetDataSet().query();
        query.in(DataIntegrationSet.FK().dataIntegrationRecords().ENTITYTYPE(), entityType);
        query.in(DataIntegrationSet.FK().dataIntegrationRecords().ENTITYID(), entityId);
        query.sortBy("id", SortMode.DESCENDING);
        return (DataIntegrationSet)query.singleValue();
    }

    public static DataIntegrationSet translateObjectToDataIntegration(String entityId, Object obj) throws InvocationTargetException, IllegalAccessException, NoSuchMethodException {
        DataIntegrationSet dis = new DataIntegrationSet();
        dis.setCreationDate(new Timestamp(new Date().getTime()));
        String entityType = obj.getClass().getSimpleName();
        DataIntegrationRecord record = DataIntegrationManager.translateObjectToFields(entityType, entityId, "U", obj);
        HashSet<DataIntegrationRecord> records = new HashSet<DataIntegrationRecord>();
        records.add(record);
        dis.setDataIntegrationRecords(records);
        return dis;
    }

    public static DataIntegrationRecord translateObjectToFields(String entityType, String entityId, String operationId, Object obj) throws InvocationTargetException, IllegalAccessException, NoSuchMethodException {
        return DataIntegrationManager.translateObjectToFields(entityType, entityId, operationId, obj, new ArrayList<Integer>());
    }

    private static DataIntegrationRecord translateObjectToFields(String entityType, String entityId, String operationId, Object obj, List<Integer> processedClasses) throws InvocationTargetException, IllegalAccessException, NoSuchMethodException {
        DataIntegrationRecord newRecord = new DataIntegrationRecord();
        newRecord.setEntityType(entityType);
        newRecord.setEntityId(entityId);
        newRecord.setOperationId(operationId);
        HashSet<DataIntegrationField> fields = new HashSet<DataIntegrationField>();
        if (obj instanceof Collection) {
            int count = 0;
            String objectListClass = null;
            for (Object listObj : (Collection)obj) {
                objectListClass = listObj.getClass().getSimpleName();
                if (listObj.getClass().getCanonicalName().startsWith("java.lang")) {
                    DataIntegrationField field = new DataIntegrationField();
                    field.setFieldId(objectListClass + "[" + count + "]");
                    field.setValue(listObj.toString());
                    field.setDataIntegrationRecordByDataIntegrationRecordId(newRecord);
                    fields.add(field);
                } else {
                    DataIntegrationRecord newRecordList = DataIntegrationManager.translateObjectToFields(objectListClass, count + "", operationId, listObj, processedClasses);
                    DataIntegrationField field = new DataIntegrationField();
                    field.setFieldId(objectListClass + "[" + count + "]");
                    field.setValue(DataIntegrationFieldType.LIST.getId());
                    field.setDataIntegrationRecordByDataIntegrationRecordId(newRecord);
                    field.setDataIntegrationRecordByRelationRecordId(newRecordList);
                    fields.add(field);
                }
                ++count;
            }
        } else {
            Map map = PropertyUtils.describe((Object)obj);
            boolean isBeanAttributes = obj instanceof AbstractBeanAttributes;
            processedClasses.add(System.identityHashCode(obj));
            for (Map.Entry entry : map.entrySet()) {
                if (entry.getKey().toString().equals("class") || isBeanAttributes && (!isBeanAttributes || entry.getValue() instanceof AbstractBeanAttributesDefinition)) continue;
                DataIntegrationField field = new DataIntegrationField();
                field.setFieldId(entry.getKey().toString());
                field.setDataIntegrationRecordByDataIntegrationRecordId(newRecord);
                if (!entry.getKey().toString().equals("class") && (entry.getValue() == null || entry.getValue().getClass().getCanonicalName().startsWith("java.lang"))) {
                    if (entry.getValue() != null) {
                        field.setValue(entry.getValue().toString());
                    }
                } else {
                    try {
                        if (!processedClasses.contains(System.identityHashCode(entry.getValue()))) {
                            DataIntegrationRecord newRecordObj = DataIntegrationManager.translateObjectToFields(entry.getValue().getClass().getSimpleName(), entry.getValue().getClass().getSimpleName() + "Element", operationId, entry.getValue(), processedClasses);
                            field.setValue(entry.getValue().getClass().getSimpleName());
                            field.setDataIntegrationRecordByDataIntegrationRecordId(newRecord);
                            field.setDataIntegrationRecordByRelationRecordId(newRecordObj);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                fields.add(field);
            }
        }
        newRecord.setDataIntegrationFieldsForDataIntegrationRecordId(fields);
        return newRecord;
    }

    public static void initEvents() throws EventException {
        IEventPublisher publisher = EventsManager.getInstance().getPublisherByID(DISetEventPublisher.class.getSimpleName());
        IEventSubscriber subscriber = EventsManager.getInstance().getSubscriberByID(DISetEventSubscriber.class.getSimpleName());
        try {
            EventsManager.getInstance().subscribeEvent(publisher, DISetEventCategory.DI_SET_AVAILABLE.getId(), subscriber);
        }
        catch (EventSubscriptionExistsException eventSubscriptionExistsException) {
            // empty catch block
        }
    }

    public static DataIntegrationSet insertDataIntegrationSet(String processId, String entityId, Object obj) throws DataSetException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        DataIntegrationSet dis = DataIntegrationManager.translateObjectToDataIntegration(entityId, obj);
        return DataIntegrationManager.insertDataIntegrationSet(dis, processId);
    }

    private static DataIntegrationSet insertDataIntegrationSet(DataIntegrationSet dis, String processId) throws DataSetException {
        boolean wasActive = DIFRepositoryFactory.openTransaction();
        IConfigurations configs = (IConfigurations)DIFIoCRegistry.getRegistry().getImplementation(IConfigurations.class);
        try {
            Session session = DIFRepositoryFactory.getSession();
            Set recordsToInsert = dis.getDataIntegrationRecords();
            dis.setDataIntegrationRecords(null);
            dis.setProcessId(processId);
            dis.setConfigId(configs.getGeneralPrefix());
            session.save((Object)dis);
            HashSet<DataIntegrationRecord> newRecords = new HashSet<DataIntegrationRecord>();
            for (DataIntegrationRecord record : recordsToInsert) {
                record = DataIntegrationManager.insertDataIntegrationRecord(session, dis, record);
                record.setRoot(true);
                if (record == null) continue;
                newRecords.add(record);
            }
            if (!wasActive) {
                DIFRepositoryFactory.getSession().getTransaction().commit();
            }
            return dis;
        }
        catch (DataSetException e) {
            e.printStackTrace();
            if (!wasActive) {
                DIFRepositoryFactory.getSession().getTransaction().rollback();
            }
            throw e;
        }
    }

    private static DataIntegrationRecord insertDataIntegrationRecord(Session session, DataIntegrationSet dis, DataIntegrationRecord record) throws DataSetException {
        Set fieldsToInsert = record.getDataIntegrationFieldsForDataIntegrationRecordId();
        if (fieldsToInsert != null && fieldsToInsert.size() > 0) {
            record.setDataIntegrationSet(dis);
            record.setDataIntegrationFieldsForDataIntegrationRecordId(null);
            session.save((Object)record);
            HashSet<DataIntegrationField> newFields = new HashSet<DataIntegrationField>();
            for (DataIntegrationField field : fieldsToInsert) {
                if (field.getDataIntegrationRecordByRelationRecordId() != null) {
                    DataIntegrationRecord newRecord = DataIntegrationManager.insertDataIntegrationRecord(session, dis, field.getDataIntegrationRecordByRelationRecordId());
                    field.setDataIntegrationRecordByRelationRecordId(newRecord);
                }
                field.setDataIntegrationRecordByDataIntegrationRecordId(record);
                session.save((Object)field);
                newFields.add(field);
            }
            return record;
        }
        return null;
    }

    public DataIntegrationField getField(DataIntegrationRecord record, String fieldPath) throws DataSetException {
        if (!this.fieldsByRootRecord.containsKey(record.getId())) {
            Map<String, DataIntegrationField> fields = this.getFields("", record);
            this.fieldsByRootRecord.put(record.getId(), fields);
        }
        return this.fieldsByRootRecord.get(record.getId()).get(fieldPath);
    }

    public String getFieldValue(DataIntegrationRecord record, String fieldPath) throws DataSetException {
        String result = null;
        DataIntegrationField field = this.getField(record, fieldPath);
        if (field != null) {
            result = field.getValue();
        }
        return result;
    }

    public Map<String, DataIntegrationField> getFields(String fieldParentName, DataIntegrationRecord record) throws DataSetException {
        if (fieldParentName != "") {
            fieldParentName = fieldParentName + ".";
        }
        HashMap<String, DataIntegrationField> fields = new HashMap<String, DataIntegrationField>();
        List<DataIntegrationField> fieldsList = this.getFieldsByRecords().get(record.getId());
        for (DataIntegrationField field : fieldsList) {
            if (field.getDataIntegrationRecordByRelationRecordId() != null) {
                fields.putAll(this.getFields(fieldParentName + field.getFieldId(), field.getDataIntegrationRecordByRelationRecordId()));
            }
            fields.put(fieldParentName + field.getFieldId(), field);
        }
        return fields;
    }

    private Map<Long, List<DataIntegrationField>> getFieldsByRecords() throws DataSetException {
        if (this.fieldsByRecord == null) {
            Query queryAllFields = dataIntegrationService.getDataIntegrationFieldDataSet().query();
            queryAllFields.equals(DataIntegrationField.FK().dataIntegrationRecordByDataIntegrationRecordId().dataIntegrationSet().ID(), this.dataIntegrationSetId.toString());
            this.fieldsByRecord = new HashMap<Long, List<DataIntegrationField>>();
            for (DataIntegrationField field : queryAllFields.asList()) {
                List<DataIntegrationField> listFields = this.fieldsByRecord.get(field.getDataIntegrationRecordByDataIntegrationRecordId().getId());
                if (listFields == null) {
                    listFields = new ArrayList<DataIntegrationField>();
                }
                listFields.add(field);
                this.fieldsByRecord.put(field.getDataIntegrationRecordByDataIntegrationRecordId().getId(), listFields);
            }
        }
        return this.fieldsByRecord;
    }

    public List<DataIntegrationField> getRecordFields(Long recordId) throws DataSetException {
        return this.getFieldsByRecords().get(recordId);
    }

    public List<DataIntegrationRecord> getRootRecords() throws DataSetException {
        Query queryRootRecord = dataIntegrationService.getDataIntegrationRecordDataSet().query();
        queryRootRecord.equals(DataIntegrationRecord.FK().dataIntegrationSet().ID(), this.dataIntegrationSetId.toString());
        queryRootRecord.equals("root", Boolean.TRUE.toString());
        return queryRootRecord.asList();
    }
}

