/*
 * Decompiled with CFR 0.152.
 */
package pt.digitalis.dif.dataintegration.events;

import pt.digitalis.dif.dataintegration.DataIntegrationManager;
import pt.digitalis.dif.dataintegration.events.publishers.DISetEventCategory;
import pt.digitalis.dif.dataintegration.events.publishers.DISetEventPublisher;
import pt.digitalis.dif.dem.managers.impl.model.IDataIntegrationService;
import pt.digitalis.dif.dem.managers.impl.model.data.DataIntegrationSet;
import pt.digitalis.dif.dem.managers.impl.model.data.Event;
import pt.digitalis.dif.dem.managers.impl.model.data.EventSubscription;
import pt.digitalis.dif.events.exceptions.EventException;
import pt.digitalis.dif.events.impl.EventsManager;
import pt.digitalis.dif.events.impl.subscriber.AbstractEventSubscriber;
import pt.digitalis.dif.events.model.BusinessCategory;
import pt.digitalis.dif.events.model.EventResult;
import pt.digitalis.dif.events.model.EventState;
import pt.digitalis.dif.ioc.DIFIoCRegistry;
import pt.digitalis.dif.presentation.views.jsp.taglibs.TagLibUtils;

public abstract class AbstractDataIntegratorEventSubscriber<T>
extends AbstractEventSubscriber {
    protected IDataIntegrationService dataIntegrationService = (IDataIntegrationService)DIFIoCRegistry.getRegistry().getImplementation(IDataIntegrationService.class);

    public abstract String asyncProcessDISet(BusinessCategory var1, DataIntegrationSet var2) throws Exception;

    protected abstract T dataIntegrationSetToIntegrate(Event var1, EventSubscription var2) throws Exception;

    protected EventResult internalProcessEvent(Event event, EventSubscription subscription) throws Exception {
        T businessObject = this.dataIntegrationSetToIntegrate(event, subscription);
        String processId = event.getPublisherId() + ":" + event.getCategoryId() + ":" + this.getID();
        DataIntegrationSet dis = DataIntegrationManager.insertDataIntegrationSet(processId, event.getBusinessId(), businessObject);
        this.syncProcessDISet(event, subscription, dis);
        EventResult result = new EventResult();
        String stageLink = TagLibUtils.getStageLinkWithParameters((String)"DataIntegrationManagerStage", (String)("&filtersSetId=" + dis.getId()));
        String link = TagLibUtils.getLink((String)stageLink, (String)("filtersSetId=" + dis.getId()), (String)" click here.", (String)"DataIntegrationManagerStage", (String)"", (String)"", (String)"_blank", (boolean)false);
        result.setBusinessResult("Data from " + businessObject.getClass().getSimpleName() + " with Id " + event.getBusinessId() + " has been integrated. For more information," + link);
        result.setState(EventState.SUCCESS);
        return result;
    }

    protected void syncProcessDISet(Event event, EventSubscription subscription, DataIntegrationSet dataIntegrationSet) throws EventException {
        EventsManager.getInstance().getPublisherByID(DISetEventPublisher.class.getSimpleName()).publishEvent(DISetEventCategory.DI_SET_AVAILABLE.getId(), dataIntegrationSet.getId().toString(), event.getUserIdThatTriggeredEvent(), false);
    }
}

