/**
 * 2016, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */

package pt.digitalis.dif.dataminer.definition;

import pt.digitalis.dif.exception.BusinessException;

/**
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a><br/>
 * @created 03/10/2016
 */
public class DashboardPersistenceNoneImpl implements IDashboardPersistence {

    /**
     * @see pt.digitalis.dif.dataminer.definition.IDashboardPersistence#isAvailable()
     */
    public boolean isAvailable()
    {
        // No persistence so we state this functionality is not available
        return false;
    }

    /**
     * @see pt.digitalis.dif.dataminer.definition.IDashboardPersistence#loadConfigurations(pt.digitalis.dif.dataminer.definition.DashboardManager)
     */
    public DashboardManager loadConfigurations(DashboardManager dashboardManager)
    {
        // Do nothing since no persistence layer exist in this implementation
        return dashboardManager;
    }

    /**
     * @see pt.digitalis.dif.dataminer.definition.IDashboardPersistence#loadIndicatorConfiguration(pt.digitalis.dif.dataminer.definition.IIndicator)
     */
    public void loadIndicatorConfiguration(IIndicator indicator)
    {
        throw new UnsupportedOperationException("No persistence implementation!");

    }

    /**
     * @see pt.digitalis.dif.dataminer.definition.IDashboardPersistence#removeIndicatorConfiguration(pt.digitalis.dif.dataminer.definition.IIndicator)
     */
    public void removeIndicatorConfiguration(IIndicator indicator)
    {
        throw new UnsupportedOperationException("No persistence implementation!");
    }

    /**
     * @see pt.digitalis.dif.dataminer.definition.IDashboardPersistence#removeIndicatorConfiguration(java.lang.String)
     */
    public void removeIndicatorConfiguration(String indicatorID)
    {
        throw new UnsupportedOperationException("No persistence implementation!");
    }

    /**
     * @see pt.digitalis.dif.dataminer.definition.IDashboardPersistence#saveAreaConfiguration(pt.digitalis.dif.dataminer.definition.Area)
     */
    public void saveAreaConfiguration(Area area) throws BusinessException
    {
        throw new UnsupportedOperationException("No persistence implementation!");
    }

    /**
     * @see pt.digitalis.dif.dataminer.definition.IDashboardPersistence#saveIndicatorConfiguration(pt.digitalis.dif.dataminer.definition.IIndicator)
     */
    public void saveIndicatorConfiguration(IIndicator indicator)
    {
        throw new UnsupportedOperationException("No persistence implementation!");
    }

}
