/**
 * 2015, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */

package pt.digitalis.dif.dataminer.session;

import java.util.List;

import pt.digitalis.dif.controller.interfaces.IDIFSession;
import pt.digitalis.dif.exception.security.IdentityManagerException;

/**
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a><br/>
 * @created 27/08/2015
 */
public interface IDDMSession {

    /**
     * @return the active profile for the user in session
     */
    public IDDMUserProfile getActiveProfile();

    /**
     * @return the active profile instance value for the user in session
     */
    public String getActiveProfileInstanceValue();

    /**
     * @return the list of the current user profiles
     */
    public List<IDDMUserProfile> getAvailableProfiles();

    /**
     * Inspector for the 'userInSessionID' attribute.
     *
     * @return the userInSessionID value
     */
    public String getUserIDInSession();

    /**
     * Performs initialization on object instance creation. Cannot be placed in the constructor since it must have no
     * parameters so that IoC can instantiate it
     *
     * @param session
     *            the session to get the initialization information from
     * @return the initialized session object
     * @throws IdentityManagerException
     */
    public IDDMSession initialize(IDIFSession session) throws IdentityManagerException;

    /**
     * Sets the new active profile (it will be added to the profile list if not already present).
     *
     * @param profile
     *            the new active profile
     * @param profileInstanceValue
     *            the active profile instance value
     */
    public void setActiveProfile(IDDMUserProfile profile, String profileInstanceValue);
}
