/**
 * 2009, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */

package pt.digitalis.dif.dataminer.definition;

/**
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a><br/>
 * @created 31 de Jan de 2013
 */
public enum ChartType {

    /** an area chart */
    AREA,

    /** horizontal bars */
    BAR,

    /** vertical bars */
    COLUMN,

    /** a line chart */
    LINE,

    /** a pie chart with data slices */
    PIE;

    /**
     * @param chartType
     *            the chart type in character representation
     * @return the desired ChartType enumeration
     */
    public static ChartType fromCharacterRepresentation(Character chartType)
    {
        switch (chartType)
        {
            case 'A':
                return AREA;
            case 'B':
                return BAR;
            case 'C':
                return COLUMN;
            case 'L':
                return LINE;
            case 'P':
                return PIE;
        }
        return null;
    }

    /**
     * @return the character representation of the chart type
     */
    public Character getCharacterRepresentation()
    {
        switch (this)
        {
            case AREA:
                return new Character('A');
            case BAR:
                return new Character('B');
            case COLUMN:
                return new Character('C');
            case LINE:
                return new Character('L');
            case PIE:
                return new Character('P');
        }
        return null;
    }
}
