/**
 * 2016, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */
package pt.digitalis.dif.dataminer.definition;

/**
 * Defined the adicional atributes available for SQL indicator types
 *
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a><br/>
 * @created 27/12/2016
 */
public interface IIndicatorSQL extends IIndicator {

    /**
     * Inspector for the 'dataSourceDescription' attribute.
     *
     * @return the dataSourceDescription value
     */
    String getDataSourceDescription();

    /**
     * Inspector for the 'materializedViews' attribute.
     *
     * @return the materializedViews value
     */
    String getMaterializedViews();

    /**
     * Inspector for the 'querySQL' attribute.
     *
     * @return the querySQL value
     */
    String getQuerySQL();

    /**
     * Modifier for the 'dataSourceDescription' attribute.
     *
     * @param dataSourceDescription
     *            the new dataSourceDescription value to set
     */
    public void setDataSourceDescription(String dataSourceDescription);

    /**
     * Modifier for the 'materializedViews' attribute.
     *
     * @param materializedViews
     *            the new materializedViews value to set
     */
    public void setMaterializedViews(String materializedViews);

    /**
     * Modifier for the 'querySQL' attribute.
     *
     * @param querySQL
     *            the new querySQL value to set
     */
    public void setQuerySQL(String querySQL);

}