package pt.digitalis.dif.dataminer.definition;

import java.util.HashMap;
import java.util.Map;

/**
 * A class that defines a DDM Dashboard SQL template to use in indicator definition/editing
 *
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a><br/>
 * @created 20/10/2016
 */
public class DashboardSQLTemplateData {

    /** a list of descriptions translations for each language (key=language,value=value) */
    public Map<String, String> descriptionTranslations;

    /**  */
    public String id;

    /**  */
    public String sqlText;

    /** a list of title translations for each language (key=language,value=value) */
    public Map<String, String> titleTranslations;

    /**
     * Default constructor
     *
     * @param id
     * @param sqlText
     */
    public DashboardSQLTemplateData(String id, String sqlText)
    {
        this.id = id;
        this.sqlText = sqlText;
        titleTranslations = new HashMap<String, String>();
        descriptionTranslations = new HashMap<String, String>();
    }

    /**
     * Adds a new language definition to this template
     *
     * @param language
     * @param title
     * @param description
     * @return the updates object (fluent interface)
     */
    public DashboardSQLTemplateData addLanguage(String language, String title, String description)
    {
        this.titleTranslations.put(language, title);
        this.descriptionTranslations.put(language, description);

        return this;
    }

    /**
     * Inspector for the 'descriptionTranslations' attribute.
     *
     * @param language
     *            the language to get
     * @return the descriptionTranslations value
     */
    public String getDescription(String language)
    {
        return this.descriptionTranslations.get(language);
    }

    /**
     * Inspector for the 'id' attribute.
     *
     * @return the id value
     */
    public String getId()
    {
        return id;
    }

    /**
     * Inspector for the 'sqlText' attribute.
     *
     * @return the sqlText value
     */
    public String getSqlText()
    {
        return sqlText;
    }

    /**
     * Inspector for the 'titleTranslations' attribute.
     *
     * @param language
     *            the desired language
     * @return the titleTranslations value
     */
    public String getTitle(String language)
    {
        return titleTranslations.get(language);
    }

    /**
     * Modifier for the 'id' attribute.
     *
     * @param id
     *            the new id value to set
     */
    public void setId(String id)
    {
        this.id = id;
    }

    /**
     * Modifier for the 'sqlText' attribute.
     *
     * @param sqlText
     *            the new sqlText value to set
     */
    public void setSqlText(String sqlText)
    {
        this.sqlText = sqlText;
    }
}