/**
 * 2012, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */

package pt.digitalis.dif.dataminer;

import java.util.Map;

import pt.digitalis.dif.dem.interfaces.IApplication;
import pt.digitalis.dif.dem.managers.IDEMManager;
import pt.digitalis.dif.dem.managers.IMessageManager;
import pt.digitalis.dif.ioc.DIFIoCRegistry;

/**
 * The Class ComQuestUtils.
 *
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a><br/>
 * @created 26 de Mar de 2013
 */
public class DDMUtils {

    /** The application. */
    private static IApplication application;

    /** the message manager. */
    private static IMessageManager messageManager = DIFIoCRegistry.getRegistry()
            .getImplementation(IMessageManager.class);

    /**
     * Inspector for the 'application' attribute.
     *
     * @return the application value
     */
    public static IApplication getApplication()
    {
        if (application == null)
            application = DIFIoCRegistry.getRegistry().getImplementation(IDEMManager.class).getApplication("ddm");

        return application;
    }

    /**
     * Gets the com quest application messages.
     *
     * @param language
     *            the current user language
     * @return the message map
     */
    public static Map<String, String> getDDMApplicationMessages(String language)
    {
        return messageManager.getMessages(getApplication(), language);
    }
}
