/**
 * 2009, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */

package pt.digitalis.dif.dataminer.definition;

/**
 * Defines the filter type for indicators
 *
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a><br/>
 * @created 5 de Mar de 2013
 */
public enum FilterType {
    /** a boolean filter */
    BOOLEAN,

    /** a date filter */
    DATE,

    /** a list of values filter */
    LOV,

    /** A number filter */
    NUMBER,

    /** A text filter */
    TEXT;

    /**
     * @param chartType
     *            the filter type in character representation
     * @return the desired FilterType enumeration
     */
    public static FilterType fromCharacterRepresentation(Character chartType)
    {
        switch (chartType)
        {
            case 'B':
                return BOOLEAN;
            case 'D':
                return DATE;
            case 'L':
                return LOV;
            case 'N':
                return NUMBER;
            case 'T':
                return TEXT;
        }
        return null;
    }

    /**
     * @return the character representation of the filter type
     */
    public Character getCharacterRepresentation()
    {
        switch (this)
        {
            case BOOLEAN:
                return new Character('B');
            case DATE:
                return new Character('D');
            case LOV:
                return new Character('L');
            case NUMBER:
                return new Character('N');
            case TEXT:
                return new Character('T');
        }
        return null;
    }
}
