/**
 * 2016, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */

package pt.digitalis.dif.dataminer.definition;

import pt.digitalis.dif.exception.BusinessException;

/**
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a><br/>
 * @created 03/10/2016
 */
public interface IDashboardPersistence {

    /**
     * @return T if the persistence layer is available
     */
    public boolean isAvailable();

    /**
     * Will process a given dashboard and update it with all changes and additions present in the persistence layer
     * configuration if they exist
     *
     * @param dashboardManager
     *            the dashboard manager to initialize
     * @return the given dashboard manager after initialization
     * @throws BusinessException
     */
    public DashboardManager loadConfigurations(DashboardManager dashboardManager) throws BusinessException;

    /**
     * Load indicator configuration.
     *
     * @param indicator
     *            the indicator
     * @throws BusinessException
     *             the business exception
     */
    public void loadIndicatorConfiguration(IIndicator indicator) throws BusinessException;

    /**
     * Removes a given indicator's configuration (will revert to default or disappear is it is a custom one)
     *
     * @param indicator
     *            the indicator to remove
     * @throws BusinessException
     */
    public void removeIndicatorConfiguration(IIndicator indicator) throws BusinessException;

    /**
     * Removes a given indicator's configuration (will revert to default or disappear is it is a custom one)
     *
     * @param indicatorID
     *            the indicator's ID to remove
     * @throws BusinessException
     */
    public void removeIndicatorConfiguration(String indicatorID) throws BusinessException;

    /**
     * Will save the area definition to load next time the dashboard initializes
     *
     * @param area
     *            the area to save
     * @throws BusinessException
     */
    public void saveAreaConfiguration(Area area) throws BusinessException;

    /**
     * Will save the indicator definition to load next time the dashboard initializes
     *
     * @param indicator
     *            the indicator to save
     * @throws BusinessException
     */
    public void saveIndicatorConfiguration(IIndicator indicator) throws BusinessException;
}
