/**
 * 2016, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */

package pt.digitalis.dif.dataminer.definition;

import java.util.List;
import java.util.Map;

import pt.digitalis.dif.controller.interfaces.IDIFSession;

// TODO: Auto-generated Javadoc
/**
 * The Interface IIndicator.
 *
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a><br/>
 * @created 03/10/2016
 */
public interface IIndicator {

    /**
     * the possible origyns an {@link IIndicator} can have.
     *
     * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a><br/>
     * @created 26/12/2016
     */
    public static enum INDICATOR_ORIGINS {
        /** Defined in the application logic (a.k.a. bundle or stock indicator) */
        APPLICATION,

        /** User defined indicator. */
        USER;
    }

    /**
     * Adds a filter to the indicator.
     *
     * @param filter
     *            the filter to add
     */
    void addFilter(Filter filter);

    /**
     * Adds a filter to the indicator.
     *
     * @param id
     *            the id
     * @param type
     *            the type
     * @param title
     *            the title
     * @param description
     *            the description
     * @param filterSQLTemplate
     *            the filter SQL template
     */
    void addFilter(String id, FilterType type, String title, String description, String filterSQLTemplate);

    /**
     * Adds a filter to the indicator.
     *
     * @param id
     *            the id
     * @param type
     *            the type
     * @param title
     *            the title
     * @param description
     *            the description
     * @param filterSQLTemplate
     *            the filter SQL template
     * @param defaultValue
     *            the default value
     */
    void addFilter(String id, FilterType type, String title, String description, String filterSQLTemplate,
            String defaultValue);

    /**
     * Adds a LOV filter to the indicator.
     *
     * @param id
     *            the id
     * @param title
     *            the title
     * @param description
     *            the description
     * @param filterSQLTemplate
     *            the filter SQL template
     * @param lovSQLQuery
     *            the lov SQL query
     */
    void addFilter(String id, String title, String description, String filterSQLTemplate, String lovSQLQuery);

    /**
     * Adds a LOV filter to the indicator.
     *
     * @param id
     *            the id
     * @param title
     *            the title
     * @param description
     *            the description
     * @param filterSQLTemplate
     *            the filter SQL template
     * @param lovSQLQuery
     *            the lov SQL query
     * @param defaultValue
     *            the default value
     */
    void addFilter(String id, String title, String description, String filterSQLTemplate, String lovSQLQuery,
            String defaultValue);

    /**
     * Adds a new managed series to the indicator. the field name will be considered the default "value" attribute
     *
     * @param chartType
     *            the chart type for this serie
     * @param unitName
     *            the measurement unit
     * @param description
     *            the description
     */
    void addSeries(ChartType chartType, String unitName, String description);

    /**
     * Adds a new managed series to the indicator.
     *
     * @param chartType
     *            the chart type for this serie
     * @param unitName
     *            the measurement unit
     * @param description
     *            the description
     * @param fieldName
     *            the total field name
     */
    void addSeries(ChartType chartType, String unitName, String description, String fieldName);

    /**
     * Inspector for the 'areaID' attribute.
     *
     * @return the areaID value
     */
    String getAreaID();

    /**
     * Inspector for the 'autoRefreshInterval' attribute.
     *
     * @return the autoRefreshInterval value
     */
    Long getAutoRefreshInterval();

    /**
     * Gets the chart types.
     *
     * @return the list of chartTypes for the indicator series
     */
    String getChartTypes();

    /**
     * Inspector for the 'description' attribute.
     *
     * @return the description value
     */
    String getDescription();

    /**
     * Inspector for the 'descriptionTitle' attribute.
     *
     * @return the descriptionTitle value
     */
    String getDescriptionTitle();

    /**
     * Searches for a filter by the given ID.
     *
     * @param filterID
     *            the filter Id to search
     * @return the filter or null if it does not exist
     */
    public Filter getFilterById(String filterID);

    /**
     * Inspector for the 'filters' attribute.
     *
     * @return the filters value
     */
    List<Filter> getFilters();

    /**
     * @return the gridColumns
     */
    public String getGridColumns();

    /**
     * Gets the group position.
     *
     * @return the groupPosition
     */
    public Long getGroupPosition();

    /**
     * Inspector for the 'groupTitle' attribute.
     *
     * @return the groupTitle value
     */
    String getGroupTitle();

    /**
     * Inspector for the 'id' attribute.
     *
     * @return the id value
     */
    String getId();

    /**
     * Inspector for the 'limitTopRecords' attribute.
     *
     * @return the limitTopRecords value
     */
    Integer getLimitTopRecords();

    /**
     * Inspector for the 'managerID' attribute.
     *
     * @return the managerID value
     */
    String getManagerID();

    /**
     * Inspector for the 'maxValue' attribute.
     *
     * @return the maxValue value
     */
    Long getMaxValue();

    /**
     * Inspector for the 'maxValueRight' attribute.
     *
     * @return the maxValueRight value
     */
    public Long getMaxValueRight();

    /**
     * Inspector for the 'origyn' attribute.
     *
     * @return the origyn value
     */
    public INDICATOR_ORIGINS getOrigyn();

    /**
     * Gets the position.
     *
     * @return the position
     */
    public Long getPosition();

    /**
     * Inspector for the 'retrictToGroups' attribute.
     *
     * @return the retrictToGroups value
     */
    List<String> getRestrictToGroups();

    /**
     * Inspector for the 'restrictToProfiles' attribute.
     *
     * @return the restrictToProfiles value
     */
    List<String> getRestrictToProfiles();

    /**
     * Inspector for the 'series' attribute.
     *
     * @return the series value
     */
    List<Series> getSeries();

    /**
     * Inspector for the 'title' attribute.
     *
     * @return the title value
     */
    String getTitle();

    /**
     * Gets the unit descriptions.
     *
     * @return the list of unitNames for the indicator series
     */
    String getUnitDescriptions();

    /**
     * Gets the unit names.
     *
     * @return the list of unitNames for the indicator series
     */
    String getUnitNames();

    /**
     * Inspector for the 'unitSuffix' attribute.
     *
     * @return the unitSuffix value
     */
    String getUnitSuffix();

    /**
     * Gets the value fields.
     *
     * @return the list of valueFields for the indicator series
     */
    String getValueFields();

    /**
     * @return the visibleFor
     */
    public String getVisibleFor();

    /**
     * Inspector for the 'xAxisTitle' attribute.
     *
     * @return the xAxisTitle value
     */
    String getxAxisTitle();

    /**
     * Inspector for the 'yAxisFieldsRight' attribute.
     *
     * @return the yAxisFieldsRight value
     */
    public List<String> getyAxisFieldsRight();

    /**
     * Inspector for the 'yAxisTitle' attribute.
     *
     * @return the yAxisTitle value
     */
    String getyAxisTitle();

    /**
     * Inspector for the 'yAxisTitleRight' attribute.
     *
     * @return the yAxisTitleRight value
     */
    public String getyAxisTitleRight();

    /**
     * Determines if the current session has been given edit access to the given indicator.<br/>
     * Edit Access: Can change the indicator definition and thus change all it's properties and behavior
     *
     * @param session
     *            the current DIF session
     * @return T if the current session has edit access
     */
    public boolean hasEditAccessToIndicator(IDIFSession session);

    /**
     * Checks for restrictions defined.
     *
     * @return T if no group nor profile restrictions are defined for this indicator
     */
    boolean hasRestrictionsDefined();

    /**
     * Checks if is chart mode.
     *
     * @return true, if is chart mode
     */
    public boolean isChartMode();

    /**
     * Inspector for the 'isEditable' attribute.
     *
     * @return the isEditable value
     */
    public boolean isEditable();

    /**
     * Inspector for the 'hasTotalField' attribute.
     *
     * @return the hasTotalField value
     */
    boolean isHasTotalField();

    /**
     * Inspector for the 'hideMarkers' attribute.
     *
     * @return the hideMarkers value
     */
    boolean isHideMarkers();

    /**
     * Inspector for the 'legend' attribute.
     *
     * @return the legend value
     */
    boolean isLegend();

    /**
     * Checks if is table mode.
     *
     * @return true, if is table mode
     */
    public boolean isTableMode();

    /**
     * Inspector for the 'timeKeys' attribute.
     *
     * @return the timeKeys value
     */
    boolean isTimeKeys();

    /**
     * Inspector for the 'useMinutes' attribute.
     *
     * @return the useMinutes value
     */
    boolean isUseMinutes();

    /**
     * Checks if is visible.
     *
     * @return the isVisible
     */
    public boolean isVisible();

    /**
     * Refreshes the underlying indicator data cache if it exists (refresh data in RAM, rebuild materialized view or
     * other persistent strategy).
     *
     * @throws Exception
     *             if any error occurs
     */
    void refreshData() throws Exception;

    /**
     * Modifier for the 'areaID' attribute.
     *
     * @param areaID
     *            the new areaID value to set
     */
    void setAreaID(String areaID);

    /**
     * Modifier for the 'autoRefreshInterval' attribute.
     *
     * @param autoRefreshInterval
     *            the new autoRefreshInterval value to set
     */
    void setAutoRefreshInterval(Long autoRefreshInterval);

    /**
     * Sets the chart mode.
     *
     * @param isChartMode
     *            the new chart mode
     */
    public void setChartMode(boolean isChartMode);

    /**
     * Modifier for the 'description' attribute.
     *
     * @param description
     *            the new description value to set
     */
    void setDescription(String description);

    /**
     * Modifier for the 'descriptionTitle' attribute.
     *
     * @param descriptionTitle
     *            the new descriptionTitle value to set
     */
    void setDescriptionTitle(String descriptionTitle);

    /**
     * Modifier for the 'isEditable' attribute.
     *
     * @param isEditable
     *            the new isEditable value to set
     */
    public void setEditable(boolean isEditable);

    /**
     * Modifier for the 'filters' attribute.
     *
     * @param filters
     *            the new filters value to set
     */
    void setFilters(List<Filter> filters);

    /**
     * @param gridColumns
     *            the gridColumns to set
     */
    public void setGridColumns(String gridColumns);

    /**
     * Sets the group position.
     *
     * @param groupPosition
     *            the groupPosition to set
     */
    public void setGroupPosition(Long groupPosition);

    /**
     * Modifier for the 'groupTitle' attribute.
     *
     * @param groupTitle
     *            the new groupTitle value to set
     */
    void setGroupTitle(String groupTitle);

    /**
     * Modifier for the 'hasTotalField' attribute.
     *
     * @param hasTotalField
     *            the new hasTotalField value to set
     */
    void setHasTotalField(boolean hasTotalField);

    /**
     * Modifier for the 'hideMarkers' attribute.
     *
     * @param hideMarkers
     *            the new hideMarkers value to set
     */
    void setHideMarkers(boolean hideMarkers);

    /**
     * Modifier for the 'id' attribute.
     *
     * @param id
     *            the new id value to set
     */
    void setId(String id);

    /**
     * Modifier for the 'legend' attribute.
     *
     * @param legend
     *            the new legend value to set
     */
    void setLegend(boolean legend);

    /**
     * Modifier for the 'limitTopRecords' attribute.
     *
     * @param limitTopRecords
     *            the new limitTopRecords value to set
     */
    void setLimitTopRecords(Integer limitTopRecords);

    /**
     * Modifier for the 'managerID' attribute.
     *
     * @param managerID
     *            the new managerID value to set
     */
    void setManagerID(String managerID);

    /**
     * Modifier for the 'maxValue' attribute.
     *
     * @param maxValue
     *            the new maxValue value to set
     */
    void setMaxValue(Long maxValue);

    /**
     * Modifier for the 'origyn' attribute.
     *
     * @param origyn
     *            the new origyn value to set
     */
    public void setOrigyn(INDICATOR_ORIGINS origyn);

    /**
     * Sets the position.
     *
     * @param position
     *            the new position
     */
    public void setPosition(Long position);

    /**
     * Modifier for the 'retrictToGroups' attribute.
     *
     * @param retrictToGroups
     *            the new retrictToGroups value to set
     */
    void setRestrictToGroups(List<String> retrictToGroups);

    /**
     * Modifier for the 'restrictToProfiles' attribute.
     *
     * @param restrictToProfiles
     *            the new restrictToProfiles value to set
     */
    void setRestrictToProfiles(List<String> restrictToProfiles);

    /**
     * Modifier for the 'series' attribute.
     *
     * @param series
     *            the new series value to set
     */
    void setSeries(List<Series> series);

    /**
     * Modifier for the 'timeKeys' attribute.
     *
     * @param timeKeys
     *            the new timeKeys value to set
     */
    void setTimeKeys(boolean timeKeys);

    /**
     * Modifier for the 'title' attribute.
     *
     * @param title
     *            the new title value to set
     */
    void setTitle(String title);

    /**
     * Modifier for the 'unitSuffix' attribute.
     *
     * @param unitSuffix
     *            the new unitSuffix value to set
     */
    void setUnitSuffix(String unitSuffix);

    /**
     * Modifier for the 'useMinutes' attribute.
     *
     * @param useMinutes
     *            the new useMinutes value to set
     */
    void setUseMinutes(boolean useMinutes);

    /**
     * Sets all passed attributes.
     *
     * @param attrs
     *            the attrs
     */
    void setValues(Map<String, String> attrs);

    /**
     * Sets the visible.
     *
     * @param isVisible
     *            the isVisible to set
     */
    public void setVisible(boolean isVisible);

    /**
     * @param visibleFor
     *            the visibleFor to set
     */
    public void setVisibleFor(String visibleFor);

    /**
     * Modifier for the 'xAxisTitle' attribute.
     *
     * @param xAxisTitle
     *            the new xAxisTitle value to set
     */
    void setxAxisTitle(String xAxisTitle);

    /**
     * Modifier for the 'yAxisTitle' attribute.
     *
     * @param yAxisTitle
     *            the new yAxisTitle value to set
     */
    void setyAxisTitle(String yAxisTitle);
}