/**
 * 2015, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */

package pt.digitalis.dif.dataminer.session;

import pt.digitalis.dif.controller.interfaces.IDIFSession;
import pt.digitalis.dif.exception.security.IdentityManagerException;
import pt.digitalis.utils.config.ConfigurationException;

/**
 * Utility class for the user injection annotation code generation process
 *
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a><br/>
 * @created 26/08/2015
 */
public class SessionUtil {

    /**
     * Creates a new DDMSession object
     *
     * @param session
     * @return the BackOfficeUser user object
     * @throws IdentityManagerException
     * @throws ConfigurationException
     */
    static public IDDMSession newDDMSession(IDIFSession session) throws IdentityManagerException, ConfigurationException
    {
        return DDMSession.getInstance(session);
    }
}
