/**
 * 2009, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */

package pt.digitalis.dif.dataminer.definition;

/**
 * Defines a Dash-board
 *
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a><br/>
 * @created 31 de Jan de 2013
 */
public class DashBoard
{

    /** the parent area ID */
    private String areaID;

    /** the ID */
    private String id;

    /** list of inner indicators. ID of the indicators that must exist in the parent area */
    private String indicatorList;

    /** the managerID */
    private String managerID;

    /** the visual template to arrange the inner indicators */
    private String template;

    /** the title */
    private String title;

    /**
     * @param areaID
     * @param id
     * @param template
     * @param title
     */
    public DashBoard(String areaID, String id, String title, String template)
    {
        super();
        this.areaID = areaID;
        this.id = id;
        this.title = title;
        this.template = template;
    }

    /**
     * Inspector for the 'areaID' attribute.
     *
     * @return the areaID value
     */
    public Area getArea()
    {
        return DashboardManager.getInstance(managerID).getAreas().get(areaID);
    }

    /**
     * Inspector for the 'areaID' attribute.
     *
     * @return the areaID value
     */
    public String getAreaID()
    {
        return areaID;
    }

    /**
     * Modifier for the 'areaID' attribute.
     *
     * @param areaID the new areaID value to set
     */
    public void setAreaID(String areaID)
    {
        this.areaID = areaID;
    }

    /**
     * Inspector for the 'id' attribute.
     *
     * @return the id value
     */
    public String getId()
    {
        return id;
    }

    /**
     * Modifier for the 'id' attribute.
     *
     * @param id the new id value to set
     */
    public void setId(String id)
    {
        this.id = id;
    }

    /**
     * Inspector for the 'indicatorList' attribute.
     *
     * @return the indicatorList value
     */
    public String getIndicatorList()
    {
        return indicatorList;
    }

    /**
     * Modifier for the 'indicatorList' attribute.
     *
     * @param indicatorList the new indicatorList value to set
     */
    public void setIndicatorList(String indicatorList)
    {
        this.indicatorList = indicatorList;
    }

    /**
     * Inspector for the 'managerID' attribute.
     *
     * @return the managerID value
     */
    public String getManagerID()
    {
        return managerID;
    }

    /**
     * Modifier for the 'managerID' attribute.
     *
     * @param managerID the new managerID value to set
     */
    public void setManagerID(String managerID)
    {
        this.managerID = managerID;
    }

    /**
     * Inspector for the 'template' attribute.
     *
     * @return the template value
     */
    public String getTemplate()
    {
        return template;
    }

    /**
     * Modifier for the 'template' attribute.
     *
     * @param template the new template value to set
     */
    public void setTemplate(String template)
    {
        this.template = template;
    }

    /**
     * Inspector for the 'title' attribute.
     *
     * @return the title value
     */
    public String getTitle()
    {
        return title;
    }

    /**
     * Modifier for the 'title' attribute.
     *
     * @param title the new title value to set
     */
    public void setTitle(String title)
    {
        this.title = title;
    }
}
