/**
 * 2013, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */

package pt.digitalis.dif.dataminer.definition;

/**
 * Define a series for an {@link IIndicator}
 *
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a><br/>
 * @created 28 de Fev de 2013
 */
public class Series
{

    /** the chart type */
    private ChartType chartType;

    /** the series description */
    private String description;

    /** the business units measured name */
    private String unitName;

    /** the value fields that defines data series. Defaults to "value", single series */
    private String valueField = "value";

    /**
     * @param chartType
     * @param unitName
     * @param description
     * @param valueField
     */
    public Series(ChartType chartType, String unitName, String description, String valueField)
    {
        super();
        this.chartType = chartType;
        this.unitName = unitName;
        this.description = description;
        this.valueField = valueField;
    }

    /**
     * Inspector for the 'chartType' attribute.
     *
     * @return the chartType value
     */
    public ChartType getChartType()
    {
        return chartType;
    }

    /**
     * Modifier for the 'chartType' attribute.
     *
     * @param chartType the new chartType value to set
     */
    public void setChartType(ChartType chartType)
    {
        this.chartType = chartType;
    }

    /**
     * Inspector for the 'description' attribute.
     *
     * @return the description value
     */
    public String getDescription()
    {
        return description;
    }

    /**
     * Modifier for the 'description' attribute.
     *
     * @param description the new description value to set
     */
    public void setDescription(String description)
    {
        this.description = description;
    }

    /**
     * Inspector for the 'unitName' attribute.
     *
     * @return the unitName value
     */
    public String getUnitName()
    {
        return unitName;
    }

    /**
     * Modifier for the 'unitName' attribute.
     *
     * @param unitName the new unitName value to set
     */
    public void setUnitName(String unitName)
    {
        this.unitName = unitName;
    }

    /**
     * Inspector for the 'valueField' attribute.
     *
     * @return the valueField value
     */
    public String getValueField()
    {
        return valueField;
    }

    /**
     * Modifier for the 'valueField' attribute.
     *
     * @param valueField the new valueField value to set
     */
    public void setValueField(String valueField)
    {
        this.valueField = valueField;
    }
}
